/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.ipsk.swing.plaf;

import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelSelector
extends JPanel
implements ActionListener {
    private JComboBox lafsComboBox;
    private UIManager.LookAndFeelInfo[] lafInfos;
    private Frame frame;

    public LookAndFeelSelector(Frame frame) {
        this.frame = frame;
        this.lafInfos = UIManager.getInstalledLookAndFeels();
        String[] lafNames = new String[this.lafInfos.length];
        for (int i = 0; i < this.lafInfos.length; ++i) {
            lafNames[i] = this.lafInfos[i].getName();
        }
        this.lafsComboBox = new JComboBox<String>(lafNames);
        this.lafsComboBox.addActionListener(this);
        this.add(this.lafsComboBox);
    }

    public static void printDefaultKeys(PrintStream out) {
        Object value;
        Object key;
        out.println("Icons:");
        Enumeration e = UIManager.getDefaults().keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            value = UIManager.get(key);
            if (!(value instanceof Icon)) continue;
            out.println(key);
        }
        out.println("Insets:");
        e = UIManager.getDefaults().keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            value = UIManager.get(key);
            if (!(value instanceof Insets)) continue;
            out.println(key);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int ind = this.lafsComboBox.getSelectedIndex();
        String className = this.lafInfos[ind].getClassName();
        try {
            UIManager.setLookAndFeel(className);
            SwingUtilities.updateComponentTreeUI(this.frame);
            this.frame.pack();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        LookAndFeelSelector.printDefaultKeys(System.out);
    }
}

