/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.URLDownloaderEvent;
import ipsk.io.URLDownloaderListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class URLDownloader
implements Runnable {
    private URL url;
    private URLConnection urlConnection;
    private int contentLength = -1;
    private int downloadLength = 0;
    private OutputStream outstream;
    private Thread thread;
    private Vector<URLDownloaderListener> listeners = new Vector();

    public URLDownloader(URL url, OutputStream outstream) {
        this.url = url;
        this.outstream = outstream;
    }

    private void open() throws IOException {
        URLConnection urlConnection = this.url.openConnection();
        this.contentLength = urlConnection.getContentLength();
    }

    public void start() throws IOException {
        this.open();
        this.thread = new Thread((Runnable)this, "Download");
        this.thread.start();
    }

    @Override
    public void run() {
        InputStream is = null;
        try {
            this.urlConnection.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        byte[] buf = new byte[2048];
        int read = 0;
        try {
            while ((read = is.read(buf)) != -1) {
                this.outstream.write(buf, 0, read);
                this.downloadLength += read;
            }
            this.updateListeners(new URLDownloaderEvent(this));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getCurrentDownloadLength() {
        return this.downloadLength;
    }

    public void addURLDownloaderListener(URLDownloaderListener l) {
        if (l != null && !this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public void removeURLDownloaderListener(URLDownloaderListener l) {
        if (l != null) {
            this.listeners.removeElement(l);
        }
    }

    protected synchronized void updateListeners(URLDownloaderEvent e) {
        for (URLDownloaderListener listener : this.listeners) {
            listener.update(e);
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }
}

