/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math;

public class ComplexFloat {
    public float real;
    public float img;

    public ComplexFloat() {
        this.real = 0.0f;
        this.img = 0.0f;
    }

    public ComplexFloat(float real, float imaginary) {
        this.real = real;
        this.img = imaginary;
    }

    public float magnitude() {
        return (float)Math.sqrt(this.real * this.real + this.img * this.img);
    }

    public ComplexFloat add(ComplexFloat addC) {
        return new ComplexFloat(this.real + addC.real, this.img + addC.img);
    }

    public ComplexFloat sub(ComplexFloat subC) {
        return new ComplexFloat(this.real - subC.real, this.img - subC.img);
    }

    public ComplexFloat mult(ComplexFloat multC) {
        float multR = this.real * multC.real - this.img * multC.img;
        float multI = this.real * multC.img + multC.real * this.img;
        return new ComplexFloat(multR, multI);
    }

    public ComplexFloat mult(float multF) {
        return new ComplexFloat(this.real * multF, this.img * multF);
    }

    public ComplexFloat div(ComplexFloat divisor) {
        float divReal = divisor.real;
        float divImg = divisor.img;
        float div = divReal * divReal + divImg * divImg;
        float divisionReal = (this.real * divReal + this.img * divImg) / div;
        float divisionImg = (divReal * this.img - this.real * divImg) / div;
        return new ComplexFloat(divisionReal, divisionImg);
    }

    public ComplexFloat div(float divisor) {
        float div = divisor * divisor;
        float divsionReal = this.real * divisor / div;
        float divsionImg = divisor * this.img / div;
        return new ComplexFloat(divsionReal, divsionImg);
    }

    public ComplexFloat conjugate() {
        return new ComplexFloat(this.real, -this.img);
    }

    public boolean equals(ComplexFloat c) {
        if (c == null) {
            return false;
        }
        return this.real == c.real && this.img == c.img;
    }

    public String toString() {
        return "Real: " + this.real + ", Img: " + this.img;
    }
}

