/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net.cookie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class SimpleCookie {
    private HashMap<String, String> props = new HashMap();
    private HashMap<String, List<String>> responseHeaders = new HashMap();

    public SimpleCookie(String cookie) {
        StringTokenizer cookieTokenizer = new StringTokenizer(cookie, ";");
        while (cookieTokenizer.hasMoreElements()) {
            String cookieProp = cookieTokenizer.nextToken().trim();
            int equalSignPos = cookieProp.indexOf(61);
            String propKey = cookieProp.substring(0, equalSignPos);
            String propValue = cookieProp.substring(equalSignPos + 1);
            this.props.put(propKey, propValue);
            List<String> resValue = this.responseHeaders.get(propKey);
            if (resValue == null) {
                resValue = new ArrayList<String>();
                this.responseHeaders.put(propKey, resValue);
            }
            resValue.add(propValue);
        }
    }

    public HashMap<String, String> getPropertyMap() {
        return this.props;
    }

    public String getProperty(String key) {
        for (String pkey : this.props.keySet()) {
            if (!pkey.equalsIgnoreCase(key)) continue;
            return this.props.get(pkey);
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean firstProp = true;
        for (String pkey : this.props.keySet()) {
            if (firstProp) {
                firstProp = false;
            } else {
                sb.append(';');
            }
            sb.append(pkey);
            sb.append('=');
            sb.append(this.props.get(pkey));
        }
        return sb.toString();
    }

    public HashMap<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }
}

