/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import ipsk.text.TableTextFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class TableWriter
extends BufferedWriter {
    private Writer writer;
    private TableTextFormat format;

    public TableWriter(Writer writer, TableTextFormat format) {
        super(writer);
        this.writer = writer;
        this.format = format;
    }

    private void writeRecord(List<String> record) throws IOException {
        int recordSize = record.size();
        for (int ui = 0; ui < recordSize; ++ui) {
            String wr = "";
            String r = record.get(ui);
            if (r != null) {
                wr = r;
            }
            this.writer.write(wr);
            if (ui >= recordSize - 1) continue;
            this.writer.write(this.format.getUnitSeparator());
        }
    }

    public void writeRecords(List<List<String>> records) throws IOException {
        int recordsSize = records.size();
        for (int ri = 0; ri < recordsSize; ++ri) {
            this.writeRecord(records.get(ri));
            if (ri >= recordsSize - 1) continue;
            this.writer.write(this.format.getRecordSeparator());
        }
    }

    public void writeGroups(List<List<List<String>>> groups) throws IOException {
        int groupsSize = groups.size();
        char[] groupSeparator = this.format.getGroupSeparator();
        for (int gi = 0; gi < groupsSize; ++gi) {
            this.writeRecords(groups.get(gi));
            if (gi >= groupsSize - 1 || groupSeparator == null) continue;
            this.writer.write(groupSeparator);
        }
    }
}

