/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math;

import ipsk.math.Complex;
import ipsk.math.DFTAlgorithm;
import java.util.Arrays;

public class FFT2
implements DFTAlgorithm {
    private int n;
    private int m;
    private double[] cosLookup;
    private double[] sinLookup;

    public FFT2(int n) {
        this.n = n;
        this.m = (int)(Math.log(n) / Math.log(2.0));
        if (n != 1 << this.m) {
            throw new RuntimeException("length N must be power of 2");
        }
        this.cosLookup = new double[n / 2];
        this.sinLookup = new double[n / 2];
        int i = 0;
        while (i < n / 2) {
            double arc = Math.PI * -2 * (double)i / (double)n;
            this.cosLookup[i] = Math.cos(arc);
            this.sinLookup[i] = Math.sin(arc);
            ++i;
        }
    }

    @Override
    public Complex[] process(double[] srcBuf) {
        double[] x = Arrays.copyOf(srcBuf, srcBuf.length);
        double[] y = new double[srcBuf.length];
        Arrays.fill(y, 0.0);
        this.fftCooleyTurkey(x, y);
        Complex[] rc = new Complex[x.length];
        int i = 0;
        while (i < x.length) {
            rc[i] = new Complex(x[i], y[i]);
            ++i;
        }
        return rc;
    }

    public void fftCooleyTurkey(double[] real, double[] img) {
        double t1;
        int n1;
        int j = 0;
        int n2 = this.n / 2;
        int i = 1;
        while (i < this.n - 1) {
            n1 = n2;
            while (j >= n1) {
                j -= n1;
                n1 /= 2;
            }
            if (i < (j += n1)) {
                t1 = real[i];
                real[i] = real[j];
                real[j] = t1;
                t1 = img[i];
                img[i] = img[j];
                img[j] = t1;
            }
            ++i;
        }
        n1 = 0;
        n2 = 1;
        i = 0;
        while (i < this.m) {
            n1 = n2;
            n2 += n2;
            int a = 0;
            j = 0;
            while (j < n1) {
                double c = this.cosLookup[a];
                double s = this.sinLookup[a];
                a += 1 << this.m - i - 1;
                int k = j;
                while (k < this.n) {
                    t1 = c * real[k + n1] - s * img[k + n1];
                    double t2 = s * real[k + n1] + c * img[k + n1];
                    real[k + n1] = real[k] - t1;
                    img[k + n1] = img[k] - t2;
                    real[k] = real[k] + t1;
                    img[k] = img[k] + t2;
                    k += n2;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public Complex[] process(Complex[] t) {
        double[] reals = new double[this.n];
        double[] imgs = new double[this.n];
        Complex[] trans = new Complex[this.n];
        int i = 0;
        while (i < this.n) {
            reals[i] = t[i].real;
            imgs[i] = t[i].img;
            ++i;
        }
        this.fftCooleyTurkey(reals, imgs);
        i = 0;
        while (i < this.n) {
            trans[i] = new Complex(reals[i], imgs[i]);
            ++i;
        }
        return trans;
    }
}

