/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.net.MIMEType;
import ipsk.net.MIMETypePrecedenceComparator;
import ipsk.text.ParserException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MIMEUtils {
    public static List<MIMEType> parseMediaRange(String mediaRangeStr) throws ParserException {
        String[] mediaStrs;
        ArrayList<QualityMIMEType> prefList = new ArrayList<QualityMIMEType>();
        String[] stringArray = mediaStrs = mediaRangeStr.trim().split("\\s*,\\s*");
        int n = mediaStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String mStr = stringArray[n2];
            String[] mediaTks = mStr.trim().split("\\s*;\\s*");
            String mTk = mediaTks[0].trim();
            double q = 1.0;
            int i = 1;
            while (i < mediaTks.length) {
                String acceptParam = mediaTks[i];
                String[] accParKeyVal = acceptParam.split("\\s*=\\s*");
                if (accParKeyVal != null && accParKeyVal.length == 2 && "q".equals(accParKeyVal[0])) {
                    q = Double.parseDouble(accParKeyVal[1]);
                }
                ++i;
            }
            MIMEType mt = MIMEType.parse(mTk);
            prefList.add(new QualityMIMEType(mt, q));
            ++n2;
        }
        Collections.sort(prefList);
        ArrayList<MIMEType> mimeList = new ArrayList<MIMEType>();
        for (QualityMIMEType qmt : prefList) {
            mimeList.add(qmt.getMimetype());
        }
        return mimeList;
    }

    public static MIMEType preferredMimeType(List<MIMEType> suppMimes, List<MIMEType> reqMimes) {
        for (MIMEType mt : reqMimes) {
            for (MIMEType suppMime : suppMimes) {
                if (!suppMime.matches(mt)) continue;
                return suppMime;
            }
        }
        return null;
    }

    static class QualityMIMEType
    implements Comparable<QualityMIMEType> {
        private MIMEType mimetype;
        private double q;

        public MIMEType getMimetype() {
            return this.mimetype;
        }

        public double getQ() {
            return this.q;
        }

        public QualityMIMEType(MIMEType mimetype, double q) {
            this.mimetype = mimetype;
            this.q = q;
        }

        @Override
        public int compareTo(QualityMIMEType o) {
            double sign = Math.signum(o.q - this.q);
            if (sign == 0.0) {
                MIMETypePrecedenceComparator mpc = new MIMETypePrecedenceComparator();
                return mpc.compare(this.getMimetype(), o.getMimetype());
            }
            return (int)sign * 2 * MIMETypePrecedenceComparator.MAX_PRECENDENCE_VALUE;
        }
    }
}

