/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.net.Upload;
import ipsk.net.UploadCache;
import ipsk.net.UploadCacheListener;
import ipsk.net.event.UploadConnectionEvent;
import ipsk.net.event.UploadEvent;
import ipsk.net.event.UploadStateChangedEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class UploadCacheUI
extends JPanel
implements UploadCacheListener,
ActionListener {
    private static final boolean DEBUG = false;
    private static int DEFAULT_REFRESH_DELAY = 500;
    private long uploadStartTime;
    private long uploadDuration;
    private ImageIcon iconTryConnect;
    private UploadCache uc;
    private ImageIcon iconConnected;
    private ImageIcon iconDisconnected;
    private JLabel connectionLabel;
    private JLabel currentUploadLabel;
    private JLabel kbyteRateLabel;
    private JProgressBar progressBar;
    private ResourceBundle rb;
    private JLabel responseLabel;
    private Timer timer;
    private DecimalFormat rateFormat;
    private boolean showUploadsTable = false;

    public UploadCacheUI(UploadCache uc) {
        super(new BorderLayout());
        this.uc = uc;
        String packageName = this.getClass().getPackage().getName();
        this.rb = ResourceBundle.getBundle(String.valueOf(packageName) + ".ResBundle");
        this.iconDisconnected = new ImageIcon(this.getClass().getResource("connect_no.png"));
        this.iconTryConnect = new ImageIcon(this.getClass().getResource("connect_creating.png"));
        this.iconConnected = new ImageIcon(this.getClass().getResource("connect_established.png"));
        JPanel connectionPanel = new JPanel(new BorderLayout());
        this.connectionLabel = new JLabel(this.iconDisconnected);
        this.responseLabel = new JLabel(uc.getResponseMessage());
        this.kbyteRateLabel = new JLabel("");
        this.rateFormat = new DecimalFormat("###.0");
        connectionPanel.add((Component)this.connectionLabel, "West");
        connectionPanel.add((Component)this.responseLabel, "Center");
        connectionPanel.add((Component)this.kbyteRateLabel, "East");
        this.currentUploadLabel = new JLabel(String.valueOf(this.rb.getString("uploading")) + ": (" + this.rb.getString("none") + ")");
        this.currentUploadLabel.setOpaque(true);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)connectionPanel, "North");
        this.add((Component)this.currentUploadLabel, "South");
        this.add((Component)this.progressBar, "Center");
        if (uc.isConnected()) {
            this.connected();
        }
        this.timer = new Timer(DEFAULT_REFRESH_DELAY, this);
        Upload currentUpload = uc.getCurrentUploadStream();
        int status = 0;
        if (currentUpload != null) {
            status = currentUpload.getStatus();
        }
        this.stateChanged(currentUpload, status);
        uc.addUploadCacheListener(this);
    }

    public void connected() {
        this.connectionLabel.setIcon(this.iconConnected);
        this.responseLabel.setText(this.uc.getResponseMessage());
    }

    public void stateChanged(Upload uvb, int state) {
        if (uvb != null) {
            if (state == 1) {
                String uploadName = uvb.getName();
                String uploadToolTip = null;
                uploadToolTip = uploadName == null ? (uploadName = uvb.getUrl().toString()) : String.valueOf(uploadName) + "\nURL: " + uvb.getUrl().toString();
                this.currentUploadLabel.setText(String.valueOf(this.rb.getString("uploading")) + ": " + uploadName);
                this.currentUploadLabel.setToolTipText(uploadToolTip);
                this.uploadDuration = 0L;
                this.uploadStartTime = System.currentTimeMillis();
                this.timer.start();
            } else if (state == 3) {
                Container parent = this.getParent();
                if (parent != null) {
                    this.currentUploadLabel.setBackground(parent.getBackground());
                }
                this.currentUploadLabel.setText(String.valueOf(this.rb.getString("uploading")) + ": (" + this.rb.getString("none") + ")");
                this.currentUploadLabel.setToolTipText("");
                this.timer.stop();
            } else if (state == -1) {
                this.currentUploadLabel.setText(String.valueOf(this.rb.getString("failed")) + ": " + uvb.getUrl().toString());
                this.currentUploadLabel.setToolTipText(String.valueOf(this.rb.getString("failed")) + ": " + uvb.getUrl().toString());
                this.currentUploadLabel.setBackground(Color.RED);
                this.timer.stop();
            }
        }
        this.responseLabel.setText(this.uc.getResponseMessage());
        this.currentUploadLabel.setMinimumSize(new Dimension(0, this.currentUploadLabel.getMinimumSize().height));
        this.setProgress();
    }

    public void disconnected() {
        this.connectionLabel.setIcon(this.iconDisconnected);
        this.responseLabel.setText(this.uc.getResponseMessage());
    }

    public void tryConnect() {
        this.connectionLabel.setIcon(this.iconTryConnect);
        this.responseLabel.setText(this.uc.getResponseMessage());
    }

    private void setProgress() {
        long totalLength = this.uc.getTotalLength();
        long toUploadLength = this.uc.getToUploadLength();
        boolean idle = this.uc.isIdle();
        float byteRate = this.uc.getByteRate();
        if (byteRate == 0.0f) {
            this.kbyteRateLabel.setText("");
        } else {
            this.kbyteRateLabel.setText(String.valueOf(this.rateFormat.format(byteRate)) + " kByte/s");
        }
        if (totalLength == 0L) {
            this.progressBar.setString(null);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(100);
        } else if (byteRate == 0.0f) {
            this.progressBar.setString("");
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setString(null);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue((int)(100L - this.uc.getGuessedToUploadLength() * 100L / totalLength));
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.setProgress();
    }

    @Override
    public void update(UploadEvent event) {
        if (event instanceof UploadConnectionEvent) {
            UploadConnectionEvent uce = (UploadConnectionEvent)event;
            UploadConnectionEvent.ConnectionState cs = uce.getConnectionState();
            if (cs.equals((Object)UploadConnectionEvent.ConnectionState.DISCONNECTED)) {
                this.disconnected();
            } else if (cs.equals((Object)UploadConnectionEvent.ConnectionState.TRY_CONNECT)) {
                this.tryConnect();
            } else if (cs.equals((Object)UploadConnectionEvent.ConnectionState.CONNECTED)) {
                this.connected();
            }
        } else if (event instanceof UploadStateChangedEvent) {
            UploadStateChangedEvent usce = (UploadStateChangedEvent)event;
            this.stateChanged(usce.getUpload(), usce.getState());
        }
    }

    public boolean isShowUploadsTable() {
        return this.showUploadsTable;
    }

    public void setShowUploadsTable(boolean showUploadsTable) {
        this.showUploadsTable = showUploadsTable;
    }
}

