//    IPS Java Utils
// 	  (c) Copyright 2016
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.

package ips.incubator.dsp;

/**
 * @author klausj
 *
 */
public class LPC {


	public static double autocorr(double[] sig, int N, int i) {
		double v = 0.0;
		for (int n = 0; n < N; n++) {
			v += sig[n] * sig[n + i];
		}
		return v;
	}

	
	public static double[] autocorr(double[] x,int n) {
		// Initialize R with autocorrelation coefficients

		// size
		int N = x.length -1;
		double[] r = new double[n+1];
		for (int i = 0; i<n+1; i++) {
			for (int j=0;j<= N-i; j++) {
				r[i] += x[j] * x[j+i];
			}
		}
		return r;
	}
	
	public static double[] process(double[] x) {
		return process(x,x.length-1);
	}
	public static double[] process(double[] x, int n) {

		double[] r=autocorr(x,n );
		return levinson(r,n);
		
		
//		
//		
//		// size
//		int N = x.length -1;
//		
//		// Initialize R with autocorrelation coefficients
//		double[] r = new double[n+1];
//		for (int i = 0; i<n+1; i++) {
//			for (int j=0;j<= N-i; j++) {
//				r[i] += x[j] * x[j+i];
//			}
//		}
//
//		double[] ak = new double[n+1];
//		ak[0] = 1.0;
//
//		double ek = r[0];
//
//		// Levinson Durbin
//		for (int k = 0; k < n; k++) {
//			
//			double lambda = 0.0;
//			for (int j=0;j<=k;j++) {
//				lambda -= ak[j] * r[k+1-j];
//			}
//
//			lambda /= ek;
//
//			for (int i=0; i<=(k + 1)/2;i++) {
//				double temp = ak[k+1-i]+lambda*ak[i];
//				ak[i] = ak[i] + lambda * ak[k+1-i];
//				ak[k+1-i] = temp;
//			}
//
//			ek *= 1.0 - lambda*lambda;
//		}
//
//		return ak;
	}
	
	
	public static double[] levinson(double[] r,int n){
		double[] a_temp=new double[n+1];
		double[] k=new double[n+1];
		double[] a=new double[n+1];
		double alpha, epsilon;         

		k[0]      = 0.0;
		a[0]      = 1.0;
		a_temp[0] = 1.0;
		alpha     = r[0];

		for(int i=1; i<=n; i++){
			epsilon = r[i];
			for(int j=1; j<i; j++){
				epsilon += a[j]*r[i-j];
			}

			a[i] = k[i] = -epsilon/alpha;
			alpha = alpha*(1.0 - k[i]*k[i]);

			for(int j=1; j<i; j++){
				a_temp[j] = a[j] + k[i]*a[i-j];
			}
			for(int j=1; j<i; j++) {
				a[j] = a_temp[j];
			}
		}
		return a;
	}


}
