/*
 * Decompiled with CFR 0.152.
 */
package ips.dom;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocUtils {
    private Document document;

    public DocUtils(Document document) {
        this.document = document;
    }

    public static List<Element> getElementsByTagName(NodeList nodelist, String name) {
        ArrayList<Element> elList = new ArrayList<Element>();
        int nlLen = nodelist.getLength();
        int i = 0;
        while (i < nlLen) {
            Node n = nodelist.item(i);
            if (1 == n.getNodeType() && name.equals(n.getNodeName())) {
                elList.add((Element)n);
            }
            ++i;
        }
        return elList;
    }

    public static List<Element> getElementsByTagName(Element element, String name) {
        NodeList nls = element.getElementsByTagName(name);
        return DocUtils.getElementsByTagName(nls, name);
    }

    public static Element getFirstElementByTagName(Element element, String name) {
        NodeList nls = element.getElementsByTagName(name);
        List<Element> elems = DocUtils.getElementsByTagName(nls, name);
        if (elems != null && elems.size() > 0) {
            return elems.get(0);
        }
        return null;
    }

    public static Element getFirstElementByTagNameWith(Element element, String name, String condTagName, String condTextValue) {
        List<Element> elems = DocUtils.getElementsByTagNameWith(element, name, condTagName, condTextValue);
        if (elems != null && elems.size() > 0) {
            return elems.get(0);
        }
        return null;
    }

    public static List<Element> getElementsByTagNameWith(Element element, String name, String condTagName, String condTextValue) {
        NodeList nls = element.getElementsByTagName(name);
        List<Element> elems = DocUtils.getElementsByTagName(nls, name);
        ArrayList<Element> matchElems = new ArrayList<Element>();
        for (Element el : elems) {
            List<Element> condElems = DocUtils.getElementsByTagName(el, condTagName);
            for (Element condElem : condElems) {
                if (!condTextValue.equals(condElem.getTextContent())) continue;
                matchElems.add(el);
            }
        }
        return matchElems;
    }

    public List<Element> getElementsByTagName(String[] hierarchyElementNames, String name) {
        Element current = this.document.getDocumentElement();
        if (current.getNodeName().equals(hierarchyElementNames[0])) {
            int i = 1;
            while (i < hierarchyElementNames.length) {
                String hElName = hierarchyElementNames[i];
                List<Element> chEls = DocUtils.getElementsByTagName(current, hElName);
                if (chEls.size() <= 0) {
                    return null;
                }
                current = chEls.get(0);
                ++i;
            }
            return DocUtils.getElementsByTagName(current, name);
        }
        return null;
    }
}

