/*
 * Decompiled with CFR 0.152.
 */
package ipsk.beans;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class PropertyNameOrder {
    public static final String PROPERTY_NAME_WILDCARD = "*";
    private String[] availableProperties;
    private ArrayList<String> order = null;

    public boolean removeAll(Collection<String> c) {
        return this.order.removeAll(c);
    }

    public PropertyNameOrder(String[] availableProperties) {
        this.availableProperties = availableProperties;
    }

    public PropertyNameOrder(Set<String> availablePropertiesSet) {
        this(availablePropertiesSet.toArray(new String[0]));
    }

    public PropertyNameOrder(PropertyDescriptor[] persistencePropertyDescriptors) {
        this.availableProperties = new String[persistencePropertyDescriptors.length];
        int i = 0;
        while (i < persistencePropertyDescriptors.length) {
            this.availableProperties[i] = persistencePropertyDescriptors[i].getName();
            ++i;
        }
    }

    public String[] getOrder() {
        if (this.order == null) {
            return this.availableProperties;
        }
        return this.order.toArray(new String[0]);
    }

    public void applyPreferredOrder(String[] prefProperties) {
        if (prefProperties == null) {
            return;
        }
        ArrayList<String> newOrder = new ArrayList<String>();
        int asteriskInsertPoint = -1;
        List<String> availList = Arrays.asList(this.availableProperties);
        int i = 0;
        while (i < prefProperties.length) {
            String prefProp = prefProperties[i];
            if (prefProp.equals(PROPERTY_NAME_WILDCARD)) {
                asteriskInsertPoint = newOrder.size();
            } else if (availList.contains(prefProp)) {
                newOrder.add(prefProp);
            }
            ++i;
        }
        if (asteriskInsertPoint >= 0) {
            int asteriskInsertPoint2 = -1;
            if (this.order != null) {
                String prefProp;
                int j = 0;
                while (j < this.order.size()) {
                    prefProp = this.order.get(j);
                    if (prefProp.equals(PROPERTY_NAME_WILDCARD)) {
                        asteriskInsertPoint = newOrder.size();
                    } else if (!newOrder.contains(prefProp)) {
                        newOrder.add(asteriskInsertPoint++, prefProp);
                    }
                    ++j;
                }
                int k = 0;
                while (k < this.availableProperties.length) {
                    prefProp = this.availableProperties[k];
                    if (!newOrder.contains(prefProp)) {
                        if (asteriskInsertPoint2 >= 0) {
                            newOrder.add(asteriskInsertPoint2++, prefProp);
                        } else {
                            newOrder.add(prefProp);
                        }
                    }
                    ++k;
                }
            } else {
                int k = 0;
                while (k < this.availableProperties.length) {
                    String prefProp = this.availableProperties[k];
                    if (!newOrder.contains(prefProp)) {
                        newOrder.add(asteriskInsertPoint++, prefProp);
                    }
                    ++k;
                }
            }
        }
        this.order = newOrder;
    }

    public void applyPreferredOrder(String prefPropertiesAsList) {
        if (prefPropertiesAsList == null) {
            return;
        }
        this.applyPreferredOrder(PropertyNameOrder.parsePropertyList(prefPropertiesAsList));
    }

    public static String[] parsePropertyList(String listAsString) {
        List<String> list = PropertyNameOrder.parsePropertyListAsList(listAsString);
        return list.toArray(new String[0]);
    }

    public static List<String> parsePropertyListAsList(String listAsString) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(listAsString, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim());
        }
        return list;
    }

    public static void main(String[] args) {
        PropertyNameOrder pno = new PropertyNameOrder(new String[]{"aaa", "bbb", "ccc", "ddd", "eee"});
        pno.applyPreferredOrder("aaa,*,bbb");
        pno.applyPreferredOrder("eee,*");
        String[] stringArray = pno.getOrder();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            System.out.println(o);
            ++n2;
        }
    }

    public ArrayList<String> getOrderArrayList() {
        return this.order;
    }
}

