/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class JPlotComponent
extends JComponent {
    private List<Value> values;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.values == null || this.values.size() == 0) {
            return;
        }
        Dimension size = this.getSize();
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        Value prevValue = null;
        double scaleX = (double)size.width / (this.maxX - this.minX);
        double scaleY = (double)size.height / (this.maxY - this.minY);
        int prevX = 0;
        int prevY = 0;
        for (Value v : this.values) {
            int x = (int)(v.x * scaleX);
            int y = (int)(v.y * scaleY);
            if (prevValue != null) {
                g.drawLine(prevX, prevY, x, y);
            }
            prevValue = v;
            prevX = x;
            prevY = y;
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
    }

    public List<Value> getValues() {
        return this.values;
    }

    public void setValues(List<Value> values) {
        this.values = values;
        this.minX = Double.MAX_VALUE;
        this.maxX = Double.MIN_VALUE;
        this.minY = Double.MAX_VALUE;
        this.maxY = Double.MIN_VALUE;
        for (Value v : values) {
            if (v.x < this.minX) {
                this.minX = v.x;
            }
            if (v.x > this.maxX) {
                this.maxX = v.x;
            }
            if (v.y < this.minY) {
                this.minY = v.y;
            }
            if (!(v.y > this.maxY)) continue;
            this.maxY = v.y;
        }
        this.repaint();
    }

    public class Value {
        public double x;
        public double y;
    }
}

