/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import ipsk.swing.AbstractLocalizableAction;
import ipsk.util.LocalizableMessage;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoManager;

public abstract class UndoAction
extends AbstractLocalizableAction {
    public static final String NAME = new String("Undo");
    public static final String ACTION_COMMAND = new String("undo");
    public static final String SHORT_DESCRIPTION_VAL = new String("Undo");
    public static final KeyStroke ACCELERATOR_VAL = KeyStroke.getKeyStroke(90, 2);
    private LocalizableMessage displayName = new LocalizableMessage(NAME);

    public UndoAction() {
        super(ACTION_COMMAND);
        this.setDisplayName(this.displayName);
        this.setAccelerator(ACCELERATOR_VAL);
    }

    @Override
    public String getActionCommand() {
        return (String)this.getValue("ActionCommandKey");
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public void update(UndoManager undoManager) {
        boolean canUndo = undoManager.canUndo();
        this.setEnabled(canUndo);
        if (canUndo) {
            this.putValue("Name", undoManager.getUndoPresentationName());
        } else {
            this.setDisplayName(this.displayName);
        }
    }
}

