/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.services;

import ipsk.util.services.ServiceDescriptor;
import ipsk.util.services.ServiceDescriptorProvider;
import ipsk.util.services.ServicesInspector;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXB;

public class ServiceDescriptorsInspector<D extends ServiceDescriptor, S>
extends ServicesInspector<S> {
    private static final boolean DEBUG = false;
    private static final String META_PATH = "META-INF";
    private static final String META_SERVICES_PATH = "META-INF/services/";
    private Class<S> serviceClass;
    public static final boolean DEFAULT_UNIQUE = true;
    private boolean unique = true;

    public ServiceDescriptorsInspector(Class<S> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public ServiceDescriptorsInspector() {
        this(null);
    }

    public List<D> getTypedServiceDescriptors(Class<S> providerClass, Class<? extends ServiceDescriptor> serviceDescriptorClass, ClassLoader cl, boolean loadImplementationClass) throws IOException {
        String providerClassname = providerClass.getName();
        ArrayList<Object> serviceDescriptorList = new ArrayList<Object>();
        HashSet<String> foundImplClassnames = new HashSet<String>();
        Enumeration<URL> psdXmlUrls = cl.getResources(META_SERVICES_PATH + serviceDescriptorClass.getName() + ".xml");
        while (psdXmlUrls.hasMoreElements()) {
            URL sdXmlUrl = psdXmlUrls.nextElement();
            InputStream sdXmlIs = sdXmlUrl.openStream();
            try {
                ServiceDescriptor sd = (ServiceDescriptor)JAXB.unmarshal((InputStream)sdXmlIs, serviceDescriptorClass);
                serviceDescriptorList.add(sd);
            }
            catch (ClassCastException sd) {
                // empty catch block
            }
        }
        Enumeration<URL> psdUrls = cl.getResources(META_SERVICES_PATH + serviceDescriptorClass.getName());
        while (psdUrls.hasMoreElements()) {
            URL sdUrl = psdUrls.nextElement();
            InputStream sdIs = sdUrl.openStream();
            List<String> implClassList = this.readServiceImplementorClassnames(sdIs);
            for (String implClassname : implClassList) {
                Class<?> sdClass = null;
                try {
                    sdClass = Class.forName(implClassname);
                    if (!serviceDescriptorClass.isAssignableFrom(sdClass)) continue;
                    ServiceDescriptor sd = (ServiceDescriptor)sdClass.newInstance();
                    serviceDescriptorList.add(sd);
                }
                catch (ClassNotFoundException sd) {
                }
                catch (InstantiationException sd) {
                }
                catch (IllegalAccessException sd) {
                    // empty catch block
                }
            }
        }
        Enumeration<URL> sdUrls = cl.getResources(META_SERVICES_PATH + ServiceDescriptor.class.getName());
        while (sdUrls.hasMoreElements()) {
            URL sdUrl = sdUrls.nextElement();
            String sdPath = sdUrl.getPath();
            int jarSepPos = sdPath.indexOf("!");
            URL jarUrl = null;
            if (jarSepPos > 0) {
                String jarPath = sdPath.substring(0, jarSepPos);
                jarUrl = new URL(sdUrl.getProtocol(), sdUrl.getHost(), jarPath);
            }
            InputStream sdIs = sdUrl.openStream();
            List<String> implClassList = this.readServiceImplementorClassnames(sdIs);
            for (String implClassname : implClassList) {
                Class<?> sdClass = null;
                try {
                    ServiceDescriptor sd;
                    String sdServiceClassName;
                    Class<?> sdServiceClass;
                    sdClass = Class.forName(implClassname);
                    if (!serviceDescriptorClass.isAssignableFrom(sdClass) || !providerClass.isAssignableFrom(sdServiceClass = Class.forName(sdServiceClassName = (sd = (ServiceDescriptor)sdClass.newInstance()).getServiceImplementationClassname())) || (foundImplClassnames.contains(implClassname) || serviceDescriptorList.contains(sd)) && this.unique) continue;
                    serviceDescriptorList.add(sd);
                    foundImplClassnames.add(implClassname);
                }
                catch (ClassNotFoundException sd) {
                }
                catch (NoClassDefFoundError sd) {
                }
                catch (InstantiationException sd) {
                }
                catch (IllegalAccessException sd) {
                    // empty catch block
                }
            }
        }
        Enumeration<URL> urls = cl.getResources(META_SERVICES_PATH + providerClassname);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            List<String> implClassList = this.readServiceImplementorClassnames(is);
            for (String implClassname : implClassList) {
                Object serviceDescriptor = null;
                if (loadImplementationClass) {
                    Class<?> sImplClass = null;
                    try {
                        Class<?>[] sImplClassIfs;
                        sImplClass = Class.forName(implClassname);
                        Class<?>[] classArray = sImplClassIfs = sImplClass.getInterfaces();
                        int n = sImplClassIfs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block27: {
                                Class<?> sImplClassIf = classArray[n2];
                                if (ServiceDescriptorProvider.class.equals(sImplClassIf)) {
                                    ServiceDescriptorProvider sdP = null;
                                    try {
                                        sdP = (ServiceDescriptorProvider)sImplClass.newInstance();
                                        Object sd = sdP.getServiceDescriptor();
                                        if (!sd.getClass().isAssignableFrom(serviceDescriptorClass)) break block27;
                                        serviceDescriptor = sd;
                                    }
                                    catch (InstantiationException e) {
                                        e.printStackTrace();
                                        break;
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                        break;
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                if ((serviceDescriptor == null || !serviceDescriptorClass.isAssignableFrom(serviceDescriptor.getClass()) || foundImplClassnames.contains(implClassname) || serviceDescriptorList.contains(serviceDescriptor)) && this.unique) continue;
                serviceDescriptorList.add(serviceDescriptor);
                foundImplClassnames.add(implClassname);
            }
        }
        return serviceDescriptorList;
    }

    public List<D> getTypedServiceDescriptors(Class<? extends ServiceDescriptor> serviceDescriptorClass) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<D> contextList = this.getTypedServiceDescriptors(this.serviceClass, serviceDescriptorClass, cl, false);
        return contextList;
    }

    public List<D> getTypedServiceDescriptors() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<D> contextList = this.getTypedServiceDescriptors(this.serviceClass, ServiceDescriptor.class, cl, false);
        return contextList;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public void setUnique(boolean unique) {
        this.unique = unique;
    }
}

