/*
 * Decompiled with CFR 0.152.
 */
package ips.dsp;

public class IIRFilter {
    protected double[] bCoeff;
    protected double[] aCoeff;
    protected double[] bDelayBuf;
    protected double[] aDelayBuf;
    protected double[] delayBuf;

    public IIRFilter(double[] bCoeff, double[] aCoeff) {
        this.bCoeff = bCoeff;
        this.aCoeff = aCoeff;
        this.bDelayBuf = new double[bCoeff.length - 1];
        this.aDelayBuf = new double[aCoeff.length];
    }

    public double step(double in) {
        double sum = this.bCoeff[0] * in;
        int i = 0;
        while (i < this.bDelayBuf.length) {
            sum += this.bCoeff[i + 1] * this.bDelayBuf[i];
            ++i;
        }
        i = 0;
        while (i < this.aDelayBuf.length - 1) {
            sum -= this.aCoeff[i + 1] * this.aDelayBuf[i];
            ++i;
        }
        i = this.bDelayBuf.length - 1;
        while (i > 0) {
            this.bDelayBuf[i] = this.bDelayBuf[i - 1];
            --i;
        }
        this.bDelayBuf[0] = in;
        i = this.aDelayBuf.length - 1;
        while (i > 0) {
            this.aDelayBuf[i] = this.aDelayBuf[i - 1];
            --i;
        }
        this.aDelayBuf[0] = sum /= this.aCoeff[0];
        return sum;
    }
}

