/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.dsp;

import ips.incubator.dsp.FormantEstimator;
import ips.incubator.dsp.LPC;
import ips.incubator.dsp.ZPlane;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.solvers.LaguerreSolver;
import org.apache.commons.math3.complex.Complex;

public class LPCFormantEstimator
implements FormantEstimator {
    private LaguerreSolver solver = new LaguerreSolver();
    private ZPlane zPlane;
    private int estimatedNrOfFormants;

    public LPCFormantEstimator(double sampleRate) {
        this.zPlane = new ZPlane(sampleRate);
        this.estimatedNrOfFormants = this.estimateNrOfFormants(sampleRate);
    }

    public int estimateNrOfFormants(double sampleRate) {
        return (int)Math.floor(2.0 + sampleRate / 1000.0);
    }

    @Override
    public Complex[] estimatePoles(double[] x, int nrPoles) {
        double[] lpcFilterCoeffs = LPC.process(x, nrPoles);
        double[] revCoeffs = new double[lpcFilterCoeffs.length];
        int i = 0;
        while (i < revCoeffs.length) {
            revCoeffs[i] = lpcFilterCoeffs[revCoeffs.length - i - 1];
            ++i;
        }
        Complex[] revLpcRoots = this.solver.solveAllComplex(revCoeffs, 0.0);
        Complex[] lpcRoots = new Complex[revLpcRoots.length];
        int j = 0;
        while (j < lpcRoots.length) {
            lpcRoots[j] = revLpcRoots[lpcRoots.length - j - 1];
            ++j;
        }
        return lpcRoots;
    }

    @Override
    public Complex[] estimatePoles(double[] x, double sampleRate) {
        return this.estimatePoles(x, this.estimateNrOfFormants(sampleRate));
    }

    @Override
    public List<Double> estimateFormantFrequencies(double[] x, int nrFormants) {
        Complex[] poles = this.estimatePoles(x, nrFormants);
        ArrayList<Double> freqs = new ArrayList<Double>();
        int i = 0;
        while (i < poles.length) {
            Complex pole = poles[i];
            if (pole.getImaginary() > 0.0) {
                freqs.add(this.zPlane.frequency(pole));
            }
            ++i;
        }
        return freqs;
    }

    @Override
    public List<Double> estimateFormantFrequencies(double[] x, double sampleRate) {
        return this.estimateFormantFrequencies(x, this.estimateNrOfFormants(sampleRate));
    }

    private double toFrequency(Complex c, double sampleRate) {
        double f = Math.atan2(c.getImaginary(), c.getReal()) * sampleRate / (Math.PI * 2);
        return f;
    }

    public static void main(String[] args) {
        double[] testX = new double[]{0.2669, 0.1695, 0.1554, 0.468, 0.419, 0.3466, 0.953, 0.9225};
        LPCFormantEstimator lfe = new LPCFormantEstimator(44100.0);
        List<Double> fmts = lfe.estimateFormantFrequencies(testX, 8);
        for (double fmt : fmts) {
            System.out.println(fmt);
        }
        System.out.println();
    }
}

