/*
 * Decompiled with CFR 0.152.
 */
package ips.net.auth.jaas;

import ips.net.auth.jaas.InetOrgPersonPrincipal;
import ips.net.auth.jaas.RolePrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LDAPLoginModule
implements LoginModule {
    private boolean debug = false;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private String baseDN;
    private String userDn;
    private InetOrgPersonPrincipal userPrincipal;
    private RolePrincipal rolePrincipal;
    private DirContext context;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (this.debug) {
            System.out.println(String.valueOf(this.getClass().getName()) + " Initialized");
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available.");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Login: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: Unsupported callback:" + uce.getCallback());
        }
        if (this.debug) {
            System.out.println("[LDAPLoginModule] user entered user name: " + this.username);
            System.out.println("[LDAPLoginModule] user entered a password");
        }
        this.baseDN = ((String)this.options.get("baseDN")).trim();
        String accountsDN = ((String)this.options.get("accountsDN")).trim();
        StringBuffer userDNBuffer = new StringBuffer("uid=");
        userDNBuffer.append(this.username);
        userDNBuffer.append(',');
        if (this.debug) {
            System.out.println("[LDAPLoginModule] accountsDN: " + accountsDN);
        }
        if (accountsDN != null && !"".equals(accountsDN)) {
            userDNBuffer.append(accountsDN);
            if (!accountsDN.endsWith(",")) {
                userDNBuffer.append(',');
            }
        }
        userDNBuffer.append(this.baseDN);
        this.userDn = userDNBuffer.toString();
        String connectionURL = (String)this.options.get("connectionURL");
        if (this.debug) {
            System.out.println("[LDAPLoginModule] try to connect to " + connectionURL + " as user " + this.userDn);
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.provider.url", connectionURL);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.principal", this.userDn);
        env.put("java.naming.security.credentials", this.password);
        try {
            this.context = new InitialDirContext(env);
            if (this.debug) {
                System.out.println("[LDAPLoginModule] successfully bound to LDAP.");
            }
            this.succeeded = true;
            return this.succeeded;
        }
        catch (NamingException e) {
            if (this.debug) {
                System.out.println("[LDAPLoginModule] Could not bind to LDAP.");
            }
            throw new FailedLoginException("Could not bind to LDAP");
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principalSet = this.subject.getPrincipals();
        try {
            Attributes attrs = this.context.getAttributes(this.userDn);
            Attribute inetOrgPersonClassAttr = attrs.get("objectClass");
            NamingEnumeration<?> objClassesEnum = inetOrgPersonClassAttr.getAll();
            while (objClassesEnum.hasMore()) {
                Object objClassObj = objClassesEnum.next();
                if (!"inetOrgPerson".equals(objClassObj)) continue;
                this.userPrincipal = new InetOrgPersonPrincipal(this.userDn, attrs);
                if (!principalSet.contains(this.userPrincipal)) {
                    principalSet.add(this.userPrincipal);
                    if (this.debug) {
                        System.out.println("[LDAPLoginModule] added InetOrgPrincipal " + this.userPrincipal.getName() + " to Subject");
                    }
                }
                if (!this.debug) continue;
                System.out.println("Displayname: " + this.userPrincipal.getAttrDisplayname());
                System.out.println("Given name: " + this.userPrincipal.getAttrGivenname());
                System.out.println("Surname: " + this.userPrincipal.getAttrSurname());
                System.out.println("E-Mail: " + this.userPrincipal.getAttrMail());
            }
        }
        catch (NamingException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        StringBuffer rolesNodeDNBuffer = new StringBuffer("");
        String rolesDN = ((String)this.options.get("rolesDN")).trim();
        if (this.debug) {
            System.out.println("[LDAPLoginModule] rolesDN option: " + rolesDN);
        }
        if (rolesDN != null && !"".equals(rolesDN)) {
            rolesNodeDNBuffer.append(rolesDN);
            if (!rolesDN.endsWith(",")) {
                rolesNodeDNBuffer.append(',');
            }
        }
        rolesNodeDNBuffer.append(this.baseDN);
        String rolesNodeDN = rolesNodeDNBuffer.toString();
        BasicAttribute objClassAttr = new BasicAttribute("objectClass", "groupOfNames");
        BasicAttribute memberAttr = new BasicAttribute("member", this.userDn);
        BasicAttributes attrs = new BasicAttributes();
        attrs.put(objClassAttr);
        attrs.put(memberAttr);
        try {
            NamingEnumeration<SearchResult> rolesSearchRes = this.context.search(rolesNodeDN, (Attributes)attrs);
            while (rolesSearchRes.hasMore()) {
                SearchResult sr = rolesSearchRes.next();
                Attributes srAttrs = sr.getAttributes();
                Attribute cnattr = srAttrs.get("cn");
                Object roleObj = cnattr.get();
                if (!(roleObj instanceof String)) continue;
                String role = (String)roleObj;
                this.rolePrincipal = new RolePrincipal(role);
                if (!principalSet.contains(this.rolePrincipal)) {
                    principalSet.add(this.rolePrincipal);
                }
                if (!this.debug) continue;
                System.out.println("[LDAPLoginModule] added RolePrincipal " + this.rolePrincipal.getName() + " to Subject");
            }
        }
        catch (NamingException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        this.username = null;
        int i = 0;
        while (i < this.password.length) {
            this.password[i] = 32;
            ++i;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                int i = 0;
                while (i < this.password.length) {
                    this.password[i] = 32;
                    ++i;
                }
                this.password = null;
            }
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrincipals().remove(this.rolePrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            int i = 0;
            while (i < this.password.length) {
                this.password[i] = 32;
                ++i;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        this.rolePrincipal = null;
        return true;
    }
}

