/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import java.io.File;

public class DeleteDirectoryWorker
extends ProgressWorker {
    private File directory;
    private boolean ignoreNotExistingDirectories = false;

    public boolean isIgnoreNotExistingDirectories() {
        return this.ignoreNotExistingDirectories;
    }

    public void setIgnoreNotExistingDirectories(boolean ignoreNotExistingDirectories) {
        this.ignoreNotExistingDirectories = ignoreNotExistingDirectories;
    }

    @Override
    public void open() throws WorkerException {
        this.progressStatus.setLength(ProgressStatus.LENGTH_UNKNOWN);
        super.open();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteDirRecursive(File dir) throws WorkerException {
        if (dir.exists()) {
            if (!dir.isDirectory()) throw new WorkerException("Not a directory:'" + dir + "'!");
            File[] childs = dir.listFiles();
            if (childs == null) {
                throw new WorkerException("Could not read directory contents of:'" + dir + "'!");
            }
            File[] fileArray = childs;
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    this.deleteDirRecursive(f);
                } else {
                    this.progressStatus.setMessage(new LocalizableMessage("Delete: " + f.getName()));
                    this.fireProgressEvent();
                    boolean deleted = f.delete();
                    if (!deleted) {
                        String errMsg = "Could not delete: " + f.getName();
                        this.progressStatus.error(new LocalizableMessage(errMsg));
                        this.fireProgressEvent();
                        throw new WorkerException(errMsg);
                    }
                }
                ++n2;
            }
            boolean deleted = dir.delete();
            if (deleted) return;
            throw new WorkerException("Could not delete:'" + dir + "'!");
        }
        if (!this.ignoreNotExistingDirectories) throw new WorkerException("Directory:'" + dir + "' does not exist!");
        this.progressStatus.setMessage(new LocalizableMessage("Ignoring not existing directory:  " + dir));
    }

    @Override
    public void doWork() throws WorkerException {
        this.progressStatus.setMessage(new LocalizableMessage("Deleting..."));
        this.deleteDirRecursive(this.directory);
        this.progressStatus.setMessage(new LocalizableMessage("Deleted."));
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }
}

