/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class TextRecordReader {
    private static int BUF_SIZE_INCREMENT = 100;
    private char[][] recordSeparators;
    private Reader sourceReader;
    private char[] buf = new char[1];
    private char[] recordBuf = new char[BUF_SIZE_INCREMENT];
    private int recordBufPos = 0;
    private char[] matchedChars;
    private int matchedCharsFilled = 0;

    public TextRecordReader(Reader sourceReader, char[][] recordSeparators) {
        this.recordSeparators = recordSeparators;
        this.sourceReader = sourceReader;
        int maxRecSeplen = 0;
        char[][] cArray = recordSeparators;
        int n = recordSeparators.length;
        int n2 = 0;
        while (n2 < n) {
            char[] recordSep = cArray[n2];
            int recordSepLen = recordSep.length;
            if (recordSepLen > maxRecSeplen) {
                maxRecSeplen = recordSepLen;
            }
            ++n2;
        }
        this.matchedChars = new char[maxRecSeplen];
    }

    private char[] createRecordBuf() {
        char[] resBuf = new char[this.recordBufPos];
        int i = 0;
        while (i < this.recordBufPos) {
            resBuf[i] = this.recordBuf[i];
            ++i;
        }
        this.recordBufPos = 0;
        return resBuf;
    }

    public char[] readRecord() throws IOException {
        while (this.sourceReader.read(this.buf) != -1) {
            char[][] cArray = this.recordSeparators;
            int n = this.recordSeparators.length;
            int n2 = 0;
            while (n2 < n) {
                char[] recordSep = cArray[n2];
                int recordSepLen = recordSep.length;
                if (this.matchedCharsFilled < recordSepLen) {
                    boolean match = true;
                    int i = 0;
                    while (i < this.matchedCharsFilled) {
                        if (this.matchedChars[i] != recordSep[i]) {
                            match = false;
                            break;
                        }
                        ++i;
                    }
                    if (match && this.buf[0] == recordSep[this.matchedCharsFilled]) {
                        this.matchedChars[this.matchedCharsFilled] = this.buf[0];
                        ++this.matchedCharsFilled;
                        if (this.matchedCharsFilled == recordSepLen) {
                            this.matchedCharsFilled = 0;
                            return this.createRecordBuf();
                        }
                    }
                }
                ++n2;
            }
            if (this.recordBuf.length <= this.recordBufPos + 1) {
                char[] newRecordBuf = new char[this.recordBufPos + BUF_SIZE_INCREMENT];
                int i = 0;
                while (i < this.recordBufPos) {
                    newRecordBuf[i] = this.recordBuf[i];
                    ++i;
                }
                this.recordBuf = newRecordBuf;
            }
            this.recordBuf[this.recordBufPos] = this.buf[0];
            ++this.recordBufPos;
        }
        if (this.recordBufPos == 0) {
            return null;
        }
        return this.createRecordBuf();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        FileReader testReader = null;
        try {
            try {
                testReader = new FileReader("/homes/klausj/TESTFILES/Tabellenimporttest.csv");
                TextRecordReader trr = new TextRecordReader(testReader, new char[][]{{'\r', '\n'}, {'\n'}, {'\r'}});
                char[] record = null;
                while ((record = trr.readRecord()) != null) {
                    System.out.println("Record: " + new String(record));
                }
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (testReader == null) return;
                try {
                    ((Reader)testReader).close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (testReader == null) return;
                try {
                    ((Reader)testReader).close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (testReader != null) {
                try {
                    ((Reader)testReader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

