/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util;

import ipsk.util.RadixConverters;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Digester {
    public static String createMD5Sum(String stringToEncode, String encodingCharset) throws NoSuchAlgorithmException {
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        byte[] ba = Charset.forName(encodingCharset).encode(stringToEncode).array();
        return RadixConverters.bytesToHex(md5Digest.digest(ba));
    }

    public static String createMD5SumWithUTF8Encoding(String stringToEncode) throws NoSuchAlgorithmException {
        return Digester.createMD5Sum(stringToEncode, "UTF-8");
    }

    public static String createMD5SumWithDefaultEncoding(String stringToEncode) throws NoSuchAlgorithmException {
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        byte[] ba = stringToEncode.getBytes();
        return RadixConverters.bytesToHex(md5Digest.digest(ba));
    }

    public static void main(String[] args) {
        String testStr = "blafasel";
        try {
            System.out.println("MD5: " + Digester.createMD5SumWithUTF8Encoding(testStr));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

