/*
 * Decompiled with CFR 0.152.
 */
package ips.dsp;

import ipsk.io.DoubleRingBuffer;
import ipsk.io.FloatStream;
import java.io.IOException;
import java.util.Arrays;

public class FIRFilter
implements FloatStream {
    private FloatStream srcStream;
    private double[] coeff;
    private DoubleRingBuffer inBuf;
    private int zeroPadding = 0;
    private int tailZeroPad = 0;
    private boolean inStreamEof = false;
    private boolean inEof = false;
    private long position = 0L;

    public FIRFilter(FloatStream srcStream, double[] coeff) {
        this.srcStream = srcStream;
        this.coeff = coeff;
        this.inBuf = new DoubleRingBuffer(coeff.length * 2);
        this.zeroPadding = coeff.length / 2 - 1;
        Arrays.fill(this.inBuf.getBuffer(), 0, this.zeroPadding, 0.0);
        this.inBuf.written(this.zeroPadding);
        this.tailZeroPad = this.zeroPadding;
    }

    private void preloadData() throws IOException {
        int wPos = this.inBuf.bufferWritePosition();
        int cAvailWrite = this.inBuf.continuosAvailableToWrite();
        int inRead = 0;
        if (!this.inStreamEof && (inRead = this.srcStream.read(this.inBuf.getBuffer(), wPos, cAvailWrite)) < 0) {
            this.inStreamEof = true;
        }
        if (this.inStreamEof) {
            if (this.tailZeroPad > 0) {
                int zeroPad = this.tailZeroPad;
                if (zeroPad > cAvailWrite) {
                    zeroPad = cAvailWrite;
                }
                Arrays.fill(this.inBuf.getBuffer(), wPos, wPos + zeroPad, 0.0);
                this.tailZeroPad -= zeroPad;
                inRead = zeroPad;
            } else {
                this.inEof = true;
            }
        }
        this.inBuf.written(inRead);
    }

    @Override
    public int read(double[] buf, int offset, int len) throws IOException {
        this.preloadData();
        if (this.inBuf.filled() < this.coeff.length) {
            if (this.inEof) {
                return -1;
            }
            return 0;
        }
        int avail = this.inBuf.filled() - this.coeff.length + 1;
        if (len > avail) {
            len = avail;
        }
        int tc = 0;
        while (tc < len) {
            buf[offset + tc] = this.calcValue();
            this.inBuf.read(1);
            ++tc;
        }
        this.position += (long)len;
        System.out.println("Position: " + this.position);
        return len;
    }

    private double calcValue() {
        double value = 0.0;
        long readPos = this.inBuf.getReadPosition();
        int i = 0;
        while (i < this.coeff.length) {
            Double bufVal = this.inBuf.valueAtPosition(readPos + (long)i);
            value += bufVal * this.coeff[i];
            ++i;
        }
        return value;
    }

    @Override
    public long skip(long skip) {
        long skipped = 0L;
        return skipped;
    }

    @Override
    public void close() throws IOException {
        this.srcStream.close();
    }
}

