/*
 * Decompiled with CFR 0.152.
 */
package ips.dsp;

import ipsk.io.FloatStream;
import java.io.IOException;

public class FIRFilterSimple
implements FloatStream {
    private FloatStream srcStream;
    private double[] coeff;
    private double[] inBuf;
    private int filled = 0;

    public FIRFilterSimple(FloatStream srcStream, double[] coeff) {
        this.srcStream = srcStream;
        this.coeff = coeff;
        this.inBuf = new double[coeff.length];
    }

    @Override
    public int read(double[] buf, int offset, int len) throws IOException {
        int inRead = this.srcStream.read(this.inBuf, this.filled, this.coeff.length - this.filled);
        if (inRead < 0) {
            return inRead;
        }
        this.filled += inRead;
        if (this.filled < this.coeff.length) {
            return 0;
        }
        boolean avail = true;
        buf[offset] = this.calcValue();
        --this.filled;
        int i = 0;
        while (i < this.filled) {
            this.inBuf[i] = this.inBuf[i + 1];
            ++i;
        }
        return 1;
    }

    private double calcValue() {
        double value = 0.0;
        int i = 0;
        while (i < this.coeff.length) {
            value += this.inBuf[i] * this.coeff[i];
            ++i;
        }
        System.out.println(value);
        return value;
    }

    @Override
    public long skip(long skip) {
        long skipped = 0L;
        return skipped;
    }

    @Override
    public void close() throws IOException {
        this.srcStream.close();
    }
}

