/*
 * Decompiled with CFR 0.152.
 */
package ipsk.sql;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class ResultSetEditor {
    private static boolean DEBUG = false;
    private int columnCount;
    private ResultSet resultSet;
    private ResultSetMetaData metaData;

    public ResultSetEditor(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.metaData = resultSet.getMetaData();
        this.columnCount = this.metaData.getColumnCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBeanValues(Object bean) throws SQLException, IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        BeanInfo bInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] propertyDescriptors = bInfo.getPropertyDescriptors();
        int i = 1;
        while (i <= this.columnCount) {
            String columnName = this.metaData.getColumnName(i);
            int j = 0;
            while (j < propertyDescriptors.length) {
                String propertyName = propertyDescriptors[j].getName();
                Class<?> propertyType = propertyDescriptors[j].getPropertyType();
                String propertyTypeName = propertyType.getName();
                Method writeMethod = propertyDescriptors[j].getWriteMethod();
                Object val = null;
                if (DEBUG) {
                    System.out.println("Set bean property: " + propertyName + " (" + propertyTypeName + ")");
                }
                if (columnName.equals(propertyName)) {
                    if (propertyType.isPrimitive()) {
                        if (propertyTypeName.equals("int")) {
                            val = new Integer(this.resultSet.getInt(i));
                        } else {
                            if (!propertyTypeName.equals("boolean")) throw new SQLException("type " + propertyName + " not supported !");
                            val = new Boolean(this.resultSet.getBoolean(i));
                        }
                    } else if (propertyTypeName.equals("java.lang.String")) {
                        val = this.resultSet.getString(i);
                    } else if (propertyTypeName.equals("java.sql.Date")) {
                        val = this.resultSet.getDate(i);
                    } else if (propertyTypeName.equals("java.sql.Timestamp")) {
                        val = this.resultSet.getTimestamp(i);
                    } else {
                        if (!propertyTypeName.equals("java.util.Date")) throw new SQLException("type " + propertyName + " not supported !");
                        val = this.resultSet.getTimestamp(i);
                    }
                    if (val != null) {
                        writeMethod.invoke(bean, val);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void updateCurrentRow(Object bean) throws IntrospectionException, IllegalArgumentException, SQLException, IllegalAccessException, InvocationTargetException {
        BeanInfo bInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] propertyDescriptors = bInfo.getPropertyDescriptors();
        int i = 1;
        while (i <= this.columnCount) {
            String columnName = this.metaData.getColumnName(i);
            int j = 0;
            while (j < propertyDescriptors.length) {
                String propertyName = propertyDescriptors[j].getName();
                Class<?> propertyType = propertyDescriptors[j].getPropertyType();
                String propertyTypeName = propertyType.getName();
                Method readMethod = propertyDescriptors[j].getReadMethod();
                if (columnName.equals(propertyName)) {
                    if (propertyType.isPrimitive()) {
                        if (propertyTypeName.equals("int")) {
                            int iVal = (Integer)readMethod.invoke(bean, new Object[0]);
                            if (DEBUG) {
                                System.out.println("Set: " + propertyName + " " + iVal);
                            }
                            this.resultSet.updateInt(i, iVal);
                        } else if (propertyTypeName.equals("boolean")) {
                            boolean bVal = (Boolean)readMethod.invoke(bean, new Object[0]);
                            if (DEBUG) {
                                System.out.println("Set: " + propertyName + " " + bVal);
                            }
                            this.resultSet.updateBoolean(i, bVal);
                        }
                    } else if (propertyTypeName.equals("java.lang.String")) {
                        String val = (String)readMethod.invoke(bean, new Object[0]);
                        if (DEBUG) {
                            System.out.println("Set: " + propertyName + " " + val);
                        }
                        if (val == null) {
                            this.resultSet.updateNull(i);
                        } else {
                            this.resultSet.updateString(i, val);
                        }
                    } else if (propertyTypeName.equals("java.sql.Date")) {
                        java.sql.Date val = (java.sql.Date)readMethod.invoke(bean, new Object[0]);
                        if (DEBUG) {
                            System.out.println("Set: " + propertyName + " " + val);
                        }
                        if (val == null) {
                            this.resultSet.updateNull(i);
                        } else {
                            this.resultSet.updateDate(i, val);
                        }
                    } else if (propertyTypeName.equals("java.sql.Timestamp")) {
                        Timestamp val = (Timestamp)readMethod.invoke(bean, new Object[0]);
                        if (DEBUG) {
                            System.out.println("Set: " + propertyName + " " + val);
                        }
                        if (val != null) {
                            this.resultSet.updateTimestamp(i, val);
                        }
                    } else if (propertyTypeName.equals("java.util.Date")) {
                        Date val = (Date)readMethod.invoke(bean, new Object[0]);
                        if (DEBUG) {
                            System.out.println("Set: " + propertyName + " " + val);
                        }
                        if (val != null) {
                            this.resultSet.updateTimestamp(i, new Timestamp(val.getTime()));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void updateRow(Object bean) throws IllegalArgumentException, IntrospectionException, SQLException, IllegalAccessException, InvocationTargetException {
        this.updateCurrentRow(bean);
        if (DEBUG) {
            System.out.println("Updating row: " + this.resultSet.getRow());
        }
        this.resultSet.updateRow();
    }

    public void insertBean(Object bean) throws IntrospectionException, IllegalArgumentException, SQLException, IllegalAccessException, InvocationTargetException {
        this.resultSet.moveToInsertRow();
        this.updateCurrentRow(bean);
        this.resultSet.insertRow();
    }
}

