/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import ipsk.swing.ServicesTableModel;
import ipsk.util.services.ServiceDescriptor;
import ipsk.util.services.ServicesInspector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;

public class JServiceSelector<S>
extends JPanel
implements ActionListener {
    private JCheckBox useDefault;
    private JTable pluginsList;
    private ServicesTableModel stm = new ServicesTableModel();
    private String selectedClassName = null;

    public JServiceSelector() {
        super(new GridBagLayout());
        this.createUI();
    }

    public void setServiceDescriptorList(List<? extends ServiceDescriptor> serviceDescriptorList) {
        this.stm.setServiceDescriptorList(serviceDescriptorList);
        this.selectClassName();
    }

    public void setPluginManager(ServicesInspector<S> pluginManager) {
        List<Object> serviceDescriptorList = new ArrayList();
        try {
            serviceDescriptorList = pluginManager.getServiceDescriptors();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "I/O Error building plugin list: " + e.getMessage(), "Plugin error", 0);
        }
        this.setServiceDescriptorList(serviceDescriptorList);
    }

    public JServiceSelector(Class<S> serviceClass) {
        super(new GridBagLayout());
        ServicesInspector<S> pluginManager = new ServicesInspector<S>(serviceClass);
        List<Object> serviceDescriptorList = new ArrayList();
        try {
            serviceDescriptorList = pluginManager.getServiceDescriptors();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "I/O Error building plugin list: " + e.getMessage(), "Plugin error", 0);
        }
        this.stm.setServiceDescriptorList(serviceDescriptorList);
        this.createUI();
    }

    private void createUI() {
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        GridBagConstraints c = new GridBagConstraints();
        JLabel useDefaultLabel = new JLabel("Use default:");
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)useDefaultLabel, c);
        this.useDefault = new JCheckBox();
        this.useDefault.setSelected(true);
        this.useDefault.addActionListener(this);
        ++c.gridx;
        this.add((Component)this.useDefault, c);
        this.pluginsList = new JTable(this.stm);
        this.pluginsList.setSelectionMode(0);
        this.pluginsList.setColumnSelectionAllowed(false);
        JTableHeader tableHeader = this.pluginsList.getTableHeader();
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)tableHeader, c);
        c.weightx = 2.0;
        c.weighty = 2.0;
        c.fill = 1;
        c.insets = new Insets(2, 5, 2, 5);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.pluginsList, c);
        this.setDependencies();
    }

    private void selectClassName() {
        if (this.selectedClassName == null) {
            this.useDefault.setSelected(true);
        } else {
            this.useDefault.setSelected(false);
            List<? extends ServiceDescriptor> pluginClasses = this.stm.getServiceDescriptorList();
            if (pluginClasses != null) {
                int i = 0;
                while (i < pluginClasses.size()) {
                    String cName = pluginClasses.get(i).getServiceImplementationClassname();
                    if (this.selectedClassName.equals(cName)) {
                        this.pluginsList.getSelectionModel().setSelectionInterval(i, i);
                        break;
                    }
                    ++i;
                }
            }
        }
        this.setDependencies();
    }

    public void setSelectedClassname(String classname) {
        this.selectedClassName = classname;
        this.selectClassName();
    }

    public String getSelectedClassname() {
        ListSelectionModel lsm;
        if (!this.useDefault.isSelected() && (lsm = this.pluginsList.getSelectionModel()) != null && !lsm.isSelectionEmpty()) {
            int selInd = lsm.getMinSelectionIndex();
            ServiceDescriptor c = this.stm.getServiceDescriptorList().get(selInd);
            return c.getServiceImplementationClassname();
        }
        return null;
    }

    private void setDependencies() {
        this.useDefault.setEnabled(this.isEnabled());
        boolean tableEnabled = !this.useDefault.isSelected();
        this.pluginsList.setEnabled(tableEnabled && this.isEnabled());
        this.pluginsList.setRowSelectionAllowed(tableEnabled);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        this.setDependencies();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setDependencies();
    }
}

