/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class JWideButton
extends JButton
implements AncestorListener {
    private static final long serialVersionUID = -664178466426652767L;

    public JWideButton() {
        this((String)null);
    }

    public JWideButton(String text) {
        super(text);
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        ButtonModel bm = this.getModel();
        Color defColor = this.getBackground();
        Color borderColor = defColor.darker().darker();
        Color compColor = defColor;
        if (!bm.isEnabled()) {
            borderColor = defColor.darker();
            compColor = defColor;
        } else if (bm.isPressed()) {
            borderColor = defColor;
            compColor = defColor.darker();
        } else if (bm.isRollover()) {
            borderColor = defColor.brighter();
            compColor = defColor;
        }
        Rectangle b = this.getBounds();
        Rectangle viewR = new Rectangle(b);
        viewR.x = 0;
        viewR.y = 0;
        g.setColor(compColor);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(borderColor);
        g.drawLine(0, 0, 0, b.height - 1);
        g.setColor(borderColor);
        g.drawLine(b.width - 1, 0, b.width - 1, b.height - 1);
        g.drawLine(clip.x, 0, clip.x + clip.width, 0);
        g.drawLine(clip.x, b.height - 1, clip.x + clip.width, b.height - 1);
        String text = this.getText();
        if (text != null) {
            FontMetrics fm = g.getFontMetrics();
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            SwingUtilities.layoutCompoundLabel(fm, text, null, 0, 0, 0, 0, viewR, iconR, textR, 0);
            if (bm.isEnabled()) {
                g.setColor(this.getForeground());
            } else {
                g.setColor(defColor.darker());
            }
            g.drawString(text, textR.x, textR.y + fm.getAscent());
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent arg0) {
        Graphics g = this.getGraphics();
        Rectangle2D maxCharBounds = g.getFontMetrics().getMaxCharBounds(g);
        this.setPreferredSize(new Dimension(100, (int)maxCharBounds.getHeight() + 2));
    }

    @Override
    public void ancestorMoved(AncestorEvent arg0) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent arg0) {
    }
}

