/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import ipsk.text.TableTextFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class TableWriter
extends BufferedWriter {
    private Writer writer;
    private TableTextFormat format;

    public TableWriter(Writer writer, TableTextFormat format) {
        super(writer);
        this.writer = writer;
        this.format = format;
    }

    private void writeRecord(List<String> record) throws IOException {
        int recordSize = record.size();
        int ui = 0;
        while (ui < recordSize) {
            String wr = "";
            String r = record.get(ui);
            if (r != null) {
                wr = r;
            }
            this.writer.write(wr);
            if (ui < recordSize - 1) {
                this.writer.write(this.format.getUnitSeparator());
            }
            ++ui;
        }
    }

    public void writeRecords(List<List<String>> records) throws IOException {
        int recordsSize = records.size();
        int ri = 0;
        while (ri < recordsSize) {
            this.writeRecord(records.get(ri));
            if (ri < recordsSize - 1) {
                this.writer.write(this.format.getRecordSeparator());
            }
            ++ri;
        }
    }

    public void writeGroups(List<List<List<String>>> groups) throws IOException {
        int groupsSize = groups.size();
        char[] groupSeparator = this.format.getGroupSeparator();
        int gi = 0;
        while (gi < groupsSize) {
            this.writeRecords(groups.get(gi));
            if (gi < groupsSize - 1 && groupSeparator != null) {
                this.writer.write(groupSeparator);
            }
            ++gi;
        }
    }
}

