/*
 * Decompiled with CFR 0.152.
 */
package ipsk.awt;

import ipsk.text.ParserException;
import java.awt.Color;

public class ColorUtils {
    public static String colorToRGBAString(Color c) {
        return "rgba(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + (float)c.getAlpha() / 255.0f + ")";
    }

    public static String colorToString(Color c) {
        String s = Color.BLACK.equals(c) ? "black" : (Color.WHITE.equals(c) ? "white" : (Color.GRAY.equals(c) ? "gray" : (Color.DARK_GRAY.equals(c) ? "darkgray" : (Color.LIGHT_GRAY.equals(c) ? "lightgray" : (Color.RED.equals(c) ? "red" : (Color.GREEN.equals(c) ? "green" : (Color.BLUE.equals(c) ? "blue" : (Color.CYAN.equals(c) ? "cyan" : (Color.MAGENTA.equals(c) ? "magenta" : (Color.YELLOW.equals(c) ? "yellow" : (Color.ORANGE.equals(c) ? "orange" : (Color.PINK.equals(c) ? "pink" : ColorUtils.colorToRGBAString(c)))))))))))));
        return s;
    }

    public static Color stringToColor(String colorString) throws ParserException {
        String cc = colorString.trim();
        Color c = null;
        if (cc.equalsIgnoreCase("black")) {
            c = Color.BLACK;
        } else if (cc.equalsIgnoreCase("white")) {
            c = Color.WHITE;
        } else if (cc.equalsIgnoreCase("gray") || cc.equalsIgnoreCase("grey")) {
            c = Color.GRAY;
        } else if (cc.equalsIgnoreCase("darkgray") || cc.equalsIgnoreCase("darkgrey")) {
            c = Color.DARK_GRAY;
        } else if (cc.equalsIgnoreCase("lightgray") || cc.equalsIgnoreCase("lightgrey")) {
            c = Color.LIGHT_GRAY;
        } else if (cc.equalsIgnoreCase("red")) {
            c = Color.RED;
        } else if (cc.equalsIgnoreCase("green")) {
            c = Color.GREEN;
        } else if (cc.equalsIgnoreCase("blue")) {
            c = Color.BLUE;
        } else if (cc.equalsIgnoreCase("cyan")) {
            c = Color.CYAN;
        } else if (cc.equalsIgnoreCase("magenta")) {
            c = Color.MAGENTA;
        } else if (cc.equalsIgnoreCase("yellow")) {
            c = Color.YELLOW;
        } else if (cc.equalsIgnoreCase("orange")) {
            c = Color.ORANGE;
        } else if (cc.equalsIgnoreCase("pink")) {
            c = Color.PINK;
        } else if (cc.startsWith("#")) {
            String cHex = cc.replaceFirst("^[#]", "").trim();
            int rgb = Integer.parseInt(cHex, 16);
            c = new Color(rgb);
        } else {
            if (cc.startsWith("rgba")) {
                String rgbaValStr = cc.replaceFirst("^rgba\\s*[(]", "").replaceFirst("\\s*[)]\\s*$", "");
                String[] rgbaVals = rgbaValStr.split("\\s*,\\s*");
                if (rgbaVals == null || rgbaVals.length != 4) {
                    throw new ParserException("Expected exactly four number values in RGBA color value: " + cc);
                }
                try {
                    int r = Integer.parseInt(rgbaVals[0]);
                    int g = Integer.parseInt(rgbaVals[1]);
                    int b = Integer.parseInt(rgbaVals[2]);
                    float aFloat = Float.parseFloat(rgbaVals[3]);
                    int a = (int)((double)aFloat * 255.0);
                    c = new Color(r, g, b, a);
                }
                catch (NumberFormatException nfe) {
                    throw new ParserException("Could not parse number in RGBA color value: " + cc);
                }
            }
            if (cc.startsWith("rgb")) {
                String rgbValStr = cc.replaceFirst("^rgb\\s*[(]", "").replaceFirst("\\s*[)]\\s*$", "");
                String[] rgbVals = rgbValStr.split("\\s*,\\s*");
                if (rgbVals == null || rgbVals.length != 3) {
                    throw new ParserException("Expected exactly three values for RGB color value: " + cc);
                }
                try {
                    int r = Integer.parseInt(rgbVals[0]);
                    int g = Integer.parseInt(rgbVals[1]);
                    int b = Integer.parseInt(rgbVals[2]);
                    c = new Color(r, g, b);
                }
                catch (NumberFormatException nfe) {
                    throw new ParserException("Could not parse number in RGB color value: " + cc);
                }
            }
        }
        return c;
    }

    public static void main(String[] args) {
        String test1Str = "blue";
        Color c3 = new Color(255, 0, 0, 128);
        try {
            Color c1 = ColorUtils.stringToColor(test1Str);
            System.out.println("String: " + test1Str + " -> Color: " + c1 + " -> String (again): " + ColorUtils.colorToString(c1) + " " + ColorUtils.colorToRGBAString(c1));
            String test2Str = "#003456";
            Color c2 = ColorUtils.stringToColor(test2Str);
            System.out.println("String: " + test2Str + " -> Color: " + c2 + " -> String (again): " + ColorUtils.colorToString(c2));
            System.out.println("String: " + ColorUtils.colorToString(c3) + " -> Color: " + c3 + " -> Color (again) " + ColorUtils.stringToColor(ColorUtils.colorToString(c3)));
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }
}

