/*
 * Decompiled with CFR 0.152.
 */
package ipsk.beans;

import ipsk.beans.DOMCodecException;
import ipsk.beans.DOMElementConvertible;
import ipsk.beans.LinkID;
import ipsk.beans.dom.DOMAttributes;
import ipsk.beans.dom.DOMCollectionElement;
import ipsk.beans.dom.DOMElement;
import ipsk.beans.dom.DOMElements;
import ipsk.beans.dom.DOMRoot;
import ipsk.beans.dom.DOMTextNodePropertyName;
import ipsk.beans.dom.RemoveIfDefault;
import ipsk.beans.dom.Temporal;
import ipsk.beans.test.Child1;
import ipsk.beans.test.Root;
import ipsk.beans.test.SuperRoot;
import ipsk.text.ParserException;
import ipsk.text.RFC3339DateTimeFormat;
import ipsk.text.StringObjectConverter;
import ipsk.xml.DOMAttribute;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMCodec {
    public static final String attributePrefix = "attribute";
    private boolean elementNameUpperCase = true;
    private Package elementsPackage;
    private DocumentBuilder db = null;

    public DOMCodec() throws DOMCodecException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new DOMCodecException(e);
        }
    }

    public DOMCodec(Package elementsPackage) throws DOMCodecException {
        this();
        this.setElementsPackage(elementsPackage);
    }

    public DOMCodec(Package elementsPackage, boolean elementNameUpperCase) throws DOMCodecException {
        this(elementsPackage);
        this.elementNameUpperCase = elementNameUpperCase;
    }

    public void setElementsPackage(Package elementsPackage) {
        this.elementsPackage = elementsPackage;
    }

    public Object readDocument(Document document) throws DOMCodecException {
        Element rootElement = document.getDocumentElement();
        return this.createObject(rootElement);
    }

    private PropertyDescriptor getPropertyDescriptorByName(PropertyDescriptor[] descriptors, String name) {
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getName().equals(name)) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }

    private PropertyDescriptor getPropertyDescriptorByArrayType(PropertyDescriptor[] descriptors, String componentTypeName) {
        PropertyDescriptor[] propertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> pdCompType;
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            Class<?> pdType = pd.getPropertyType();
            if (pdType.isArray() && (pdCompType = pdType.getComponentType()).getSimpleName().equals(componentTypeName)) {
                return pd;
            }
            ++n2;
        }
        return null;
    }

    private Object createObject(Element e) throws DOMCodecException {
        return this.createObject(e, null);
    }

    private Object createObject(Element e, Class<?> c) throws DOMCodecException {
        BeanInfo bi = null;
        String className = null;
        if (c != null) {
            className = c.getName();
        }
        String elementClassname = new String(e.getTagName());
        if (!this.elementNameUpperCase) {
            elementClassname = new String(String.valueOf(elementClassname.substring(0, 1).toUpperCase(Locale.ENGLISH)) + elementClassname.substring(1));
        }
        if (className == null) {
            className = this.elementsPackage.getName();
            className = className.concat("." + elementClassname);
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                throw new DOMCodecException(e1);
            }
        }
        Object bean = null;
        if (c.isPrimitive() || Number.class.isAssignableFrom(c)) {
            NodeList childs = e.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                Node node = childs.item(i);
                short nodeType = node.getNodeType();
                if (nodeType == 3) {
                    try {
                        bean = StringObjectConverter.stringToObject(node.getNodeValue(), c);
                    }
                    catch (ParserException e1) {
                        throw new DOMCodecException(e1);
                    }
                }
                ++i;
            }
        } else if (c.isEnum()) {
            ?[] enumConstants;
            int nodeType;
            String enumString = null;
            NodeList childs = e.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                Node node = childs.item(i);
                nodeType = node.getNodeType();
                if (nodeType == 3) {
                    enumString = node.getNodeValue();
                }
                ++i;
            }
            ?[] objArray = enumConstants = c.getEnumConstants();
            int n = enumConstants.length;
            nodeType = 0;
            while (nodeType < n) {
                Enum eConst;
                Object enumConstant = objArray[nodeType];
                if (enumConstant instanceof Enum && (eConst = (Enum)enumConstant).toString().equals(enumString)) {
                    bean = eConst;
                    break;
                }
                ++nodeType;
            }
        } else if (UUID.class.equals(c)) {
            String uuidString = null;
            NodeList childs = e.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                Node node = childs.item(i);
                short nodeType = node.getNodeType();
                if (nodeType == 3) {
                    uuidString = node.getNodeValue();
                }
                ++i;
            }
            bean = UUID.fromString(uuidString);
        } else {
            try {
                bean = c.newInstance();
            }
            catch (Exception ex) {
                throw new DOMCodecException(ex);
            }
            if (c.equals(String.class)) {
                NodeList childs = e.getChildNodes();
                int i = 0;
                while (i < childs.getLength()) {
                    Node node = childs.item(i);
                    short nodeType = node.getNodeType();
                    if (nodeType == 3) {
                        bean = node.getNodeValue();
                    }
                    ++i;
                }
            } else {
                NamedNodeMap attrMap = e.getAttributes();
                if (bean instanceof ipsk.xml.DOMElement) {
                    int len = attrMap.getLength();
                    DOMAttribute[] attributes = new DOMAttribute[len];
                    int i22 = 0;
                    while (i22 < len) {
                        Attr attrNode = (Attr)attrMap.item(i22);
                        attributes[i22] = new DOMAttribute(attrNode.getName(), attrNode.getValue());
                        ++i22;
                    }
                    ((ipsk.xml.DOMElement)bean).setAttributes(attributes);
                    NodeList i22 = e.getChildNodes();
                } else {
                    PropertyDescriptor pd;
                    try {
                        bi = Introspector.getBeanInfo(c);
                    }
                    catch (IntrospectionException e1) {
                        throw new DOMCodecException(e1);
                    }
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                    if (attrMap != null) {
                        int len = attrMap.getLength();
                        DOMAttributes domAttributesAnnot = c.getAnnotation(DOMAttributes.class);
                        String[] domAttributeNames = null;
                        if (domAttributesAnnot != null) {
                            domAttributeNames = domAttributesAnnot.value();
                        }
                        int i = 0;
                        while (i < len) {
                            Attr attrNode = (Attr)attrMap.item(i);
                            String attrName = attrNode.getName();
                            String propName = null;
                            if (domAttributeNames != null) {
                                propName = attrName;
                            } else {
                                propName = new String(attributePrefix + attrName.substring(0, 1).toUpperCase(Locale.ENGLISH));
                                propName = propName.concat(attrName.substring(1));
                            }
                            PropertyDescriptor pd2 = this.getPropertyDescriptorByName(pds, propName);
                            if (pd2 == null) {
                                throw new DOMCodecException("Cannot associate attribute '" + propName + "'");
                            }
                            Class<?> propertyType = pd2.getPropertyType();
                            Method setMethod = pd2.getWriteMethod();
                            try {
                                Object attributeValue = null;
                                if (propertyType.isEnum()) {
                                    ?[] enumConstants;
                                    ?[] objArray = enumConstants = propertyType.getEnumConstants();
                                    int n = enumConstants.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Object enumConstant = objArray[n2];
                                        if (enumConstant instanceof Enum) {
                                            Enum eConst = (Enum)enumConstant;
                                            if (attrNode.getValue().equals(eConst.toString())) {
                                                attributeValue = eConst;
                                                break;
                                            }
                                        }
                                        ++n2;
                                    }
                                } else if (Date.class.isAssignableFrom(propertyType)) {
                                    RFC3339DateTimeFormat dateTimeFormat = new RFC3339DateTimeFormat();
                                    attributeValue = dateTimeFormat.parseObject(attrNode.getValue());
                                } else {
                                    attributeValue = StringObjectConverter.stringToObject(attrNode.getValue(), propertyType);
                                }
                                setMethod.invoke(bean, attributeValue);
                            }
                            catch (Exception ex) {
                                throw new DOMCodecException("Cannot associate attribute '" + propName + "'", ex);
                            }
                            ++i;
                        }
                    }
                    String textNodePropertyName = null;
                    DOMTextNodePropertyName textNodePropAnno = c.getAnnotation(DOMTextNodePropertyName.class);
                    if (textNodePropAnno != null && (pd = this.getPropertyDescriptorByName(pds, textNodePropertyName = textNodePropAnno.value())) != null) {
                        String text = null;
                        Method setMethod = pd.getWriteMethod();
                        NodeList nl = e.getChildNodes();
                        int i = 0;
                        while (i < nl.getLength()) {
                            Node n = nl.item(i);
                            if (n.getNodeType() == 3) {
                                String nodeText = n.getTextContent();
                                text = text == null ? new String(nodeText) : text.concat(nodeText);
                            }
                            ++i;
                        }
                        try {
                            setMethod.invoke(bean, text);
                        }
                        catch (Exception e1) {
                            throw new DOMCodecException("Cannot set '" + textNodePropertyName + "' text node property!", e1);
                        }
                    }
                    NodeList childs = e.getChildNodes();
                    HashSet<String> arrayMethodsSet = new HashSet<String>();
                    int i = 0;
                    while (i < childs.getLength()) {
                        Node node = childs.item(i);
                        short nodeType = node.getNodeType();
                        if (nodeType == 1) {
                            String strValue;
                            Node propValueNode;
                            Node collElementNode;
                            int j;
                            NodeList collNodelist;
                            Collection<Object> coll;
                            Object newParamElement;
                            Type setType;
                            Class setClass;
                            Type rt;
                            DOMCollectionElement domCollectionElementAnno;
                            String collElementName;
                            Element childElement = (Element)node;
                            String tagName = childElement.getTagName();
                            String propName = tagName.substring(0, 1).toLowerCase(Locale.ENGLISH);
                            propName = propName.concat(tagName.substring(1));
                            PropertyDescriptor pd3 = this.getPropertyDescriptorByName(pds, propName = propName.replace('_', '.'));
                            if (pd3 == null && (pd3 = this.getPropertyDescriptorByArrayType(pds, tagName)) == null) {
                                throw new DOMCodecException("Cannot associate element '" + propName + "'");
                            }
                            Class<?> propertyType = pd3.getPropertyType();
                            HashMap param = null;
                            Method setMethod = pd3.getWriteMethod();
                            if (propertyType.isArray()) {
                                Class<?> arrType = propertyType.getComponentType();
                                Method getMethod = pd3.getReadMethod();
                                if (arrayMethodsSet.contains(propName)) {
                                    try {
                                        param = getMethod.invoke(bean, new Object[0]);
                                    }
                                    catch (Exception e2) {
                                        throw new DOMCodecException(e2);
                                    }
                                }
                                if (param == null) {
                                    param = Array.newInstance(arrType, 0);
                                    try {
                                        setMethod.invoke(bean, param);
                                    }
                                    catch (Exception e3) {
                                        throw new DOMCodecException(e3);
                                    }
                                }
                                int arrLen = Array.getLength(param) + 1;
                                HashSet oldParam = param;
                                param = Array.newInstance(arrType, arrLen);
                                int a = 0;
                                while (a < arrLen - 1) {
                                    Array.set(param, a, Array.get(oldParam, a));
                                    ++a;
                                }
                                Object newParamElement2 = null;
                                newParamElement2 = this.createObject(childElement, arrType);
                                Array.set(param, arrLen - 1, newParamElement2);
                                arrayMethodsSet.add(propName);
                            } else if (List.class.isAssignableFrom(propertyType)) {
                                Method getMethod = pd3.getReadMethod();
                                collElementName = propName;
                                domCollectionElementAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                                if (domCollectionElementAnno != null) {
                                    collElementName = domCollectionElementAnno.collectionElementName();
                                }
                                rt = getMethod.getGenericReturnType();
                                setClass = null;
                                if (rt instanceof ParameterizedType) {
                                    Type[] listTypes = ((ParameterizedType)rt).getActualTypeArguments();
                                    if (listTypes.length != 1) {
                                        throw new DOMCodecException("List with more than one parameterized types!");
                                    }
                                    setType = listTypes[0];
                                    if (setType != null && setType instanceof Class) {
                                        setClass = (Class)setType;
                                    }
                                } else {
                                    throw new DOMCodecException("Cannot convert unparametrized collection types: " + propName + " !");
                                }
                                try {
                                    param = getMethod.invoke(bean, new Object[0]);
                                }
                                catch (Exception e2) {
                                    throw new DOMCodecException(e2);
                                }
                                if (param == null) {
                                    param = new HashSet();
                                    try {
                                        setMethod.invoke(bean, param);
                                    }
                                    catch (Exception e3) {
                                        throw new DOMCodecException(e3);
                                    }
                                }
                                newParamElement = null;
                                coll = (List)((Object)param);
                                if (domCollectionElementAnno == null) {
                                    newParamElement = this.createObject(childElement, setClass);
                                    coll.add(newParamElement);
                                } else {
                                    collNodelist = childElement.getElementsByTagName(collElementName);
                                    int collElementsCount = collNodelist.getLength();
                                    j = 0;
                                    while (j < collElementsCount) {
                                        collElementNode = collNodelist.item(j);
                                        if (collElementNode instanceof Element) {
                                            Element collElementElement = (Element)collElementNode;
                                            newParamElement = this.createObject(collElementElement, setClass);
                                            coll.add(newParamElement);
                                        }
                                        ++j;
                                    }
                                }
                            } else if (Set.class.isAssignableFrom(propertyType)) {
                                Method getMethod = pd3.getReadMethod();
                                collElementName = propName;
                                domCollectionElementAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                                if (domCollectionElementAnno != null) {
                                    collElementName = domCollectionElementAnno.collectionElementName();
                                }
                                rt = getMethod.getGenericReturnType();
                                setClass = null;
                                if (rt instanceof ParameterizedType) {
                                    Type[] setTypes = ((ParameterizedType)rt).getActualTypeArguments();
                                    if (setTypes.length != 1) {
                                        throw new DOMCodecException("Set with more than one parameterized types!");
                                    }
                                    setType = setTypes[0];
                                    if (setType != null && setType instanceof Class) {
                                        setClass = (Class)setType;
                                    }
                                } else {
                                    throw new DOMCodecException("Cannot convert unparametrized collection types: " + propName + " !");
                                }
                                try {
                                    param = getMethod.invoke(bean, new Object[0]);
                                }
                                catch (Exception e2) {
                                    throw new DOMCodecException(e2);
                                }
                                if (param == null) {
                                    param = new HashSet();
                                    try {
                                        setMethod.invoke(bean, param);
                                    }
                                    catch (Exception e3) {
                                        throw new DOMCodecException(e3);
                                    }
                                }
                                newParamElement = null;
                                coll = (Set)((Object)param);
                                if (domCollectionElementAnno == null) {
                                    newParamElement = this.createObject(childElement, setClass);
                                    coll.add(newParamElement);
                                } else {
                                    collNodelist = childElement.getElementsByTagName(collElementName);
                                    int collElementsCount = collNodelist.getLength();
                                    j = 0;
                                    while (j < collElementsCount) {
                                        collElementNode = collNodelist.item(j);
                                        if (collElementNode instanceof Element) {
                                            Element collElementElement = (Element)collElementNode;
                                            newParamElement = this.createObject(collElementElement, setClass);
                                            coll.add(newParamElement);
                                        }
                                        ++j;
                                    }
                                }
                            } else if (Map.class.isAssignableFrom(propertyType)) {
                                Method getMethod = pd3.getReadMethod();
                                collElementName = propName;
                                domCollectionElementAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                                if (domCollectionElementAnno != null) {
                                    collElementName = domCollectionElementAnno.collectionElementName();
                                }
                                rt = getMethod.getGenericReturnType();
                                Class mapKeyClass = null;
                                Class mapValueClass = null;
                                if (rt instanceof ParameterizedType) {
                                    Type[] mapTypes = ((ParameterizedType)rt).getActualTypeArguments();
                                    if (mapTypes.length != 2) {
                                        throw new DOMCodecException("Map with more than two parameterized types!");
                                    }
                                    Type mapKeyType = mapTypes[0];
                                    Type mapValType = mapTypes[1];
                                    if (mapKeyType != null && mapKeyType instanceof Class && mapValType != null && mapValType instanceof Class) {
                                        mapKeyClass = (Class)mapKeyType;
                                        mapValueClass = (Class)mapValType;
                                    }
                                } else {
                                    throw new DOMCodecException("Cannot convert unparametrized collection types: " + propName + " !");
                                }
                                try {
                                    param = getMethod.invoke(bean, new Object[0]);
                                }
                                catch (Exception e2) {
                                    throw new DOMCodecException(e2);
                                }
                                if (param == null) {
                                    param = new HashMap();
                                    try {
                                        setMethod.invoke(bean, param);
                                    }
                                    catch (Exception e3) {
                                        throw new DOMCodecException(e3);
                                    }
                                }
                                Object newParamElement3 = null;
                                Map map = param;
                                NodeList mapNodelist = childElement.getChildNodes();
                                int mapElementsCount = mapNodelist.getLength();
                                Object currentKey = null;
                                int j2 = 0;
                                while (j2 < mapElementsCount) {
                                    Element mapElementElement;
                                    String nName;
                                    Node mapElementNode = mapNodelist.item(j2);
                                    if (mapElementNode instanceof Element && "entry".equals(nName = (mapElementElement = (Element)mapElementNode).getNodeName())) {
                                        NodeList entryValList;
                                        int entryValCount;
                                        NodeList entryKeyList = mapElementElement.getElementsByTagName("key");
                                        int entryKeyCount = entryKeyList.getLength();
                                        if (entryKeyCount > 1) {
                                            throw new DOMCodecException("Ambigious keys for map entry!");
                                        }
                                        Object key = null;
                                        if (entryKeyCount == 1) {
                                            Node keyNode = entryKeyList.item(0);
                                            String nv = keyNode.getTextContent();
                                            try {
                                                key = StringObjectConverter.stringToObject(nv, mapKeyClass);
                                            }
                                            catch (ParserException e1) {
                                                throw new DOMCodecException("Cannot convert map key " + nv + " to object!");
                                            }
                                        }
                                        if ((entryValCount = (entryValList = mapElementElement.getElementsByTagName("value")).getLength()) > 1) {
                                            throw new DOMCodecException("Ambigious values for map entry!");
                                        }
                                        Object val = null;
                                        if (entryValCount == 1) {
                                            Node valNode = entryValList.item(0);
                                            String valText = valNode.getTextContent();
                                            try {
                                                val = StringObjectConverter.stringToObject(valText, mapValueClass);
                                            }
                                            catch (ParserException e1) {
                                                throw new DOMCodecException("Cannot convert map value " + valText + " to object!");
                                            }
                                        }
                                        map.put(key, val);
                                    }
                                    ++j2;
                                }
                            } else if (propertyType.isPrimitive() || propertyType.equals(Boolean.class)) {
                                NodeList propertyValueNodes = childElement.getChildNodes();
                                int k = 0;
                                while (k < propertyValueNodes.getLength()) {
                                    propValueNode = propertyValueNodes.item(k);
                                    if (propValueNode.getNodeType() == 3) {
                                        strValue = propValueNode.getNodeValue();
                                        try {
                                            param = StringObjectConverter.stringToObject(strValue, propertyType);
                                            break;
                                        }
                                        catch (ParserException e1) {
                                            throw new DOMCodecException(e1);
                                        }
                                    }
                                    ++k;
                                }
                            } else if (propertyType.equals(String.class)) {
                                if (propName.equals(textNodePropertyName)) {
                                    param = childElement.getTextContent();
                                } else {
                                    NodeList propertyValueNodes = childElement.getChildNodes();
                                    int k = 0;
                                    while (k < propertyValueNodes.getLength()) {
                                        propValueNode = propertyValueNodes.item(k);
                                        if (propValueNode.getNodeType() == 3) {
                                            strValue = propValueNode.getNodeValue();
                                            try {
                                                param = StringObjectConverter.stringToObject(strValue, propertyType);
                                                break;
                                            }
                                            catch (ParserException e1) {
                                                throw new DOMCodecException(e1);
                                            }
                                        }
                                        ++k;
                                    }
                                }
                            } else if (!propertyType.isPrimitive()) {
                                param = this.createObject(childElement, propertyType);
                            }
                            try {
                                setMethod.invoke(bean, param);
                            }
                            catch (Exception ex) {
                                throw new DOMCodecException(ex);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        return bean;
    }

    public Object copy(Object bean) throws DOMCodecException {
        return this.copy(bean, new IdentityHashMap<Object, Object>());
    }

    public Object copy(Object bean, IdentityHashMap<Object, Object> copiedObjects) throws DOMCodecException {
        if (copiedObjects != null && copiedObjects.containsKey(bean)) {
            Object copiedObj = copiedObjects.get(bean);
            return copiedObj;
        }
        AbstractCollection beanCopy = null;
        BeanInfo bi = null;
        Class<?> c = bean.getClass();
        if (c.isArray()) {
            try {
                int length = Array.getLength(bean);
                Class<?> compType = c.getComponentType();
                beanCopy = Array.newInstance(c.getComponentType(), length);
                copiedObjects.put(bean, beanCopy);
                int i = 0;
                while (i < length) {
                    Object val = Array.get(bean, i);
                    if (compType.equals(String.class)) {
                        Array.set(beanCopy, i, new String((String)val));
                    } else {
                        Array.set(beanCopy, i, this.copy(val, copiedObjects));
                    }
                    ++i;
                }
                return beanCopy;
            }
            catch (Exception e) {
                throw new DOMCodecException(e);
            }
        }
        if (Collection.class.isAssignableFrom(c)) {
            try {
                Collection beanColl = (Collection)bean;
                Class<?> collClass = beanColl.getClass();
                AbstractCollection copyColl = null;
                try {
                    copyColl = (ArrayList)collClass.newInstance();
                }
                catch (InstantiationException ie) {
                    if (bean instanceof List) {
                        copyColl = new ArrayList();
                    }
                    if (bean instanceof Set) {
                        copyColl = new HashSet();
                    }
                    throw new DOMCodecException(ie);
                }
                copiedObjects.put(bean, copyColl);
                for (Object co : beanColl) {
                    Object coCopy = this.copy(co, copiedObjects);
                    copyColl.add(coCopy);
                }
                beanCopy = copyColl;
                return beanCopy;
            }
            catch (Exception e) {
                throw new DOMCodecException(e);
            }
        }
        if (c.isEnum()) {
            beanCopy = bean;
        } else if (Number.class.isAssignableFrom(c)) {
            beanCopy = bean;
        } else if (UUID.class.equals(c)) {
            beanCopy = bean;
        } else {
            try {
                beanCopy = c.newInstance();
                copiedObjects.put(bean, beanCopy);
            }
            catch (Exception e) {
                throw new DOMCodecException(e);
            }
        }
        try {
            bi = Introspector.getBeanInfo(bean.getClass());
        }
        catch (Exception ex) {
            throw new DOMCodecException(ex);
        }
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        int i = 0;
        while (i < pds.length) {
            PropertyDescriptor pd = pds[i];
            Class<?> pClass = pd.getPropertyType();
            Method getMethod = pd.getReadMethod();
            Method setMethod = pd.getWriteMethod();
            Object child = null;
            if (getMethod == null) {
                throw new DOMCodecException("DOM codec copy error: Property \"" + pd.getName() + "\" of class " + c.getCanonicalName() + " has no getter method !");
            }
            try {
                child = getMethod.invoke(bean, new Object[0]);
                if (child != null && setMethod != null) {
                    Object childCopy;
                    if (pClass.isArray()) {
                        childCopy = this.copy(child, copiedObjects);
                        setMethod.invoke((Object)beanCopy, childCopy);
                    } else if (String.class.equals(pClass)) {
                        setMethod.invoke((Object)beanCopy, new String((String)child));
                    } else if (pClass.isPrimitive()) {
                        setMethod.invoke((Object)beanCopy, child);
                    } else if (Boolean.class.equals(pClass)) {
                        setMethod.invoke((Object)beanCopy, new Boolean((Boolean)child));
                    } else if (Byte.class.equals(pClass)) {
                        setMethod.invoke((Object)beanCopy, new Byte((Byte)child));
                    } else if (Short.class.equals(pClass)) {
                        setMethod.invoke((Object)beanCopy, new Short((Short)child));
                    } else if (Integer.class.equals(pClass)) {
                        setMethod.invoke((Object)beanCopy, new Integer((Integer)child));
                    } else if (Long.class.equals(pClass)) {
                        setMethod.invoke((Object)beanCopy, new Long((Long)child));
                    } else if (Float.class.equals(pClass)) {
                        setMethod.invoke((Object)beanCopy, new Float(((Float)child).floatValue()));
                    } else if (Double.class.equals(pClass)) {
                        setMethod.invoke((Object)beanCopy, new Double((Double)child));
                    } else if (URL.class.equals(pClass)) {
                        setMethod.invoke((Object)beanCopy, new URL(((URL)child).toExternalForm()));
                    } else if (URI.class.equals(pClass)) {
                        setMethod.invoke((Object)beanCopy, new URI(((URI)child).toString()));
                    } else if (!Class.class.equals(pClass)) {
                        childCopy = this.copy(child, copiedObjects);
                        setMethod.invoke((Object)beanCopy, childCopy);
                    }
                }
            }
            catch (Exception ex) {
                throw new DOMCodecException(ex);
            }
            ++i;
        }
        return beanCopy;
    }

    public Document createDocument(Object bean) throws DOMCodecException {
        Document document = this.db.newDocument();
        Class<?> c = bean.getClass();
        String pPackName = c.getPackage().getName();
        String elementName = c.getName().substring(pPackName.length() + 1);
        elementName = elementName.replace('$', '_');
        if (!this.elementNameUpperCase) {
            elementName = new String(String.valueOf(elementName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + elementName.substring(1));
        }
        Element e = document.createElement(elementName);
        document.appendChild(e);
        try {
            this.appendToDOM(document, e, bean);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DOMCodecException(ex);
        }
        return document;
    }

    private String getAttributePropertyName(String pdName) {
        if (attributePrefix == null) {
            return null;
        }
        if (pdName.startsWith(attributePrefix)) {
            String attrName = pdName.substring(attributePrefix.length());
            attrName = new String(String.valueOf(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + attrName.substring(1));
            return attrName;
        }
        return null;
    }

    public void appendToDOM(Document d, Element e, Object bean) throws DOMCodecException {
        this.appendToDOM(d, e, bean, false);
    }

    public void appendToDOM(Document d, Element e, Object bean, boolean appendIfDefault) throws DOMCodecException {
        Object pd;
        PropertyDescriptor pd2;
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        Type[] types;
        BeanInfo bi = null;
        Class<?> c = bean.getClass();
        d = e instanceof Document ? (Document)((Object)e) : e.getOwnerDocument();
        Type[] typeArray = types = c.getGenericInterfaces();
        int n4 = types.length;
        int n5 = 0;
        while (n5 < n4) {
            Type t = typeArray[n5];
            if (t.equals(DOMElementConvertible.class)) {
                e.appendChild(((DOMElementConvertible)bean).toElement(d));
                return;
            }
            ++n5;
        }
        Object beanDefault = null;
        try {
            bi = Introspector.getBeanInfo(c);
            if (!Number.class.isAssignableFrom(c)) {
                beanDefault = c.newInstance();
            }
        }
        catch (Exception ex) {
            throw new DOMCodecException(ex);
        }
        PropertyDescriptor[] allPds = bi.getPropertyDescriptors();
        PropertyDescriptor[] pds = null;
        DOMElements domElementsAnnot = c.getAnnotation(DOMElements.class);
        String[] domElementNames = null;
        DOMTextNodePropertyName domTextNodePropAnnot = c.getAnnotation(DOMTextNodePropertyName.class);
        String domTextNodePropertyName = null;
        boolean domTextNodeAsCDATA = false;
        if (domTextNodePropAnnot != null) {
            domTextNodePropertyName = domTextNodePropAnnot.value();
            domTextNodeAsCDATA = domTextNodePropAnnot.asCDATANode();
        }
        DOMAttributes domAttributesAnnot = c.getAnnotation(DOMAttributes.class);
        String[] domAttributeNames = null;
        if (domAttributesAnnot != null) {
            domAttributeNames = domAttributesAnnot.value();
        }
        if (domElementsAnnot != null) {
            domElementNames = domElementsAnnot.value();
            ArrayList<PropertyDescriptor> pdsTmp = new ArrayList<PropertyDescriptor>();
            objectArray = domElementNames;
            n3 = domElementNames.length;
            n2 = 0;
            while (n2 < n3) {
                Object elmName = objectArray[n2];
                PropertyDescriptor[] propertyDescriptorArray = allPds;
                n = allPds.length;
                int n6 = 0;
                while (n6 < n) {
                    pd2 = propertyDescriptorArray[n6];
                    if (pd2.getName().equals(elmName)) {
                        pdsTmp.add(pd2);
                        break;
                    }
                    ++n6;
                }
                ++n2;
            }
            pds = pdsTmp.toArray(new PropertyDescriptor[0]);
        } else if (domAttributeNames != null) {
            ArrayList<Object> pdsArrList = new ArrayList<Object>();
            objectArray = allPds;
            n3 = allPds.length;
            n2 = 0;
            while (n2 < n3) {
                pd = objectArray[n2];
                boolean isAttr = false;
                String[] stringArray = domAttributeNames;
                int n7 = domAttributeNames.length;
                n = 0;
                while (n < n7) {
                    String a = stringArray[n];
                    if (((FeatureDescriptor)pd).getName().equals(a)) {
                        isAttr = true;
                        break;
                    }
                    ++n;
                }
                if (!isAttr) {
                    pdsArrList.add(pd);
                }
                ++n2;
            }
            pds = pdsArrList.toArray(new PropertyDescriptor[0]);
        } else {
            pds = allPds;
        }
        if (domAttributeNames != null) {
            String[] stringArray = domAttributeNames;
            n2 = domAttributeNames.length;
            int pd3 = 0;
            while (pd3 < n2) {
                String attrName = stringArray[pd3];
                int i = 0;
                while (i < allPds.length) {
                    pd2 = allPds[i];
                    String pdName = pd2.getName();
                    if (pdName.equals(attrName)) {
                        Method getMethod = pd2.getReadMethod();
                        Object child = null;
                        Object defChild = null;
                        try {
                            child = getMethod.invoke(bean, new Object[0]);
                            defChild = getMethod.invoke(beanDefault, new Object[0]);
                        }
                        catch (Exception ex) {
                            throw new DOMCodecException(ex);
                        }
                        if (!(child == null || defChild != null && defChild.equals(child))) {
                            String attrText;
                            Class<?> childClass = child.getClass();
                            if (Date.class.isAssignableFrom(childClass)) {
                                RFC3339DateTimeFormat rfcDateTimeFormat = new RFC3339DateTimeFormat();
                                Temporal temporalAnno = getMethod.getAnnotation(Temporal.class);
                                if (temporalAnno != null && Temporal.Type.DATE.equals((Object)temporalAnno.type())) {
                                    rfcDateTimeFormat.setTemporalType(RFC3339DateTimeFormat.TemporalType.DATE);
                                }
                                attrText = rfcDateTimeFormat.format(child);
                            } else {
                                attrText = child.toString();
                            }
                            e.setAttribute(attrName, attrText);
                        }
                    }
                    ++i;
                }
                ++pd3;
            }
        } else {
            int i = 0;
            while (i < allPds.length) {
                pd = allPds[i];
                Class<?> pClass = ((PropertyDescriptor)pd).getPropertyType();
                Method getMethod = ((PropertyDescriptor)pd).getReadMethod();
                String pdName = ((FeatureDescriptor)pd).getName();
                Object child = null;
                Object defChild = null;
                try {
                    child = getMethod.invoke(bean, new Object[0]);
                    defChild = getMethod.invoke(beanDefault, new Object[0]);
                }
                catch (Exception ex) {
                    throw new DOMCodecException(ex);
                }
                if (pClass.equals(String.class)) {
                    if (child != null && (defChild == null || !((String)defChild).equals((String)child)) && pdName.startsWith(attributePrefix)) {
                        String attrName = pdName.substring(attributePrefix.length());
                        attrName = new String(String.valueOf(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + attrName.substring(1));
                        e.setAttribute(attrName, (String)child);
                    }
                } else if (pClass.isPrimitive() && child != null && (defChild == null || !defChild.equals(child)) && pdName.startsWith(attributePrefix)) {
                    String attrName = pdName.substring(attributePrefix.length());
                    attrName = new String(String.valueOf(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + attrName.substring(1));
                    e.setAttribute(attrName, child.toString());
                }
                ++i;
            }
        }
        if (domTextNodePropertyName != null) {
            int i = 0;
            while (i < allPds.length) {
                PropertyDescriptor pd4 = allPds[i];
                if (domTextNodePropertyName.equals(pd4.getName())) {
                    Class<?> pClass = pd4.getPropertyType();
                    Method getMethod = pd4.getReadMethod();
                    if (!String.class.equals(pClass)) {
                        throw new DOMCodecException("Text node property \"" + domTextNodePropertyName + "\" must be String type!");
                    }
                    Object child = null;
                    try {
                        child = getMethod.invoke(bean, new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new DOMCodecException(ex);
                    }
                    if (child != null) {
                        if (domTextNodeAsCDATA) {
                            e.appendChild(d.createCDATASection((String)child));
                        } else {
                            e.setTextContent((String)child);
                        }
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < pds.length) {
            Element se;
            Element se2;
            String attrName;
            int riDAnnot3;
            PropertyDescriptor[] e15;
            Element se3;
            String pdElementName;
            Element se4;
            DOMCollectionElement domCollElemAnno;
            String collElementName;
            LinkID linkIdanno;
            Method arrChGetMethod;
            Object arrChPd;
            PropertyDescriptor[] arrChPds;
            Class collClass;
            Type collParametrizedType;
            ParameterizedType prt;
            Type rt;
            Object collChLinkIDPd;
            LinkID linkIdanno22;
            PropertyDescriptor[] propertyDescriptorArray;
            PropertyDescriptor pd5 = pds[i];
            Class<?> pClass = pd5.getPropertyType();
            Method getMethod = pd5.getReadMethod();
            DOMElement propElemAnno = getMethod.getAnnotation(DOMElement.class);
            String pdName = pd5.getName();
            Object child = null;
            Object defChild = null;
            try {
                child = getMethod.invoke(bean, new Object[0]);
                defChild = getMethod.invoke(beanDefault, new Object[0]);
            }
            catch (Exception ex) {
                throw new DOMCodecException(ex);
            }
            if (pClass.isArray()) {
                if (!(child == null || defChild != null && defChild.equals(child))) {
                    Class<?> arrClass = pClass.getComponentType();
                    DOMRoot domRootAnno = arrClass.getAnnotation(DOMRoot.class);
                    PropertyDescriptor arrChLinkIDPd = null;
                    if (domRootAnno != null) {
                        PropertyDescriptor[] arrChPds2;
                        BeanInfo arrChBi = null;
                        try {
                            arrChBi = Introspector.getBeanInfo(arrClass);
                        }
                        catch (IntrospectionException e12) {
                            throw new DOMCodecException(e12);
                        }
                        propertyDescriptorArray = arrChPds2 = arrChBi.getPropertyDescriptors();
                        int n8 = arrChPds2.length;
                        int n9 = 0;
                        while (n9 < n8) {
                            PropertyDescriptor arrChPd2 = propertyDescriptorArray[n9];
                            Method arrChGetMethod2 = arrChPd2.getReadMethod();
                            linkIdanno22 = arrChGetMethod2.getAnnotation(LinkID.class);
                            if (linkIdanno22 != null) {
                                arrChLinkIDPd = arrChPd2;
                                break;
                            }
                            ++n9;
                        }
                    }
                    if (arrClass.isArray()) {
                        throw new DOMCodecException("Multidimension arrays cannot be mapped !");
                    }
                    if (child != null) {
                        int a = 0;
                        while (a < Array.getLength(child)) {
                            Element se5;
                            Object arrChild = Array.get(child, a);
                            if (arrClass.equals(String.class)) {
                                se5 = d.createElement(pdName);
                                se5.appendChild(d.createTextNode((String)arrChild));
                                e.appendChild(se5);
                            } else if (arrClass.isPrimitive()) {
                                se5 = d.createElement(pdName);
                                se5.appendChild(d.createTextNode(arrChild.toString()));
                                e.appendChild(se5);
                            } else if (arrClass.equals(Boolean.class)) {
                                se5 = d.createElement(pdName);
                                se5.appendChild(d.createTextNode(arrChild.toString()));
                                e.appendChild(se5);
                            } else if (!pClass.equals(Class.class)) {
                                String pdElementName2 = null;
                                if (propElemAnno != null) {
                                    pdElementName2 = propElemAnno.name();
                                }
                                if (pdElementName2 == null) {
                                    if (this.elementNameUpperCase) {
                                        pdElementName2 = pdName.substring(0, 1).toUpperCase(Locale.ENGLISH);
                                        pdElementName2 = pdElementName2.concat(pd5.getName().substring(1));
                                    } else {
                                        pdElementName2 = new String(pdName);
                                    }
                                }
                                Element se6 = d.createElement(pdElementName2);
                                e.appendChild(se6);
                                if (arrChild != null) {
                                    if (domRootAnno != null) {
                                        Object linkVal;
                                        Method rMethod = arrChLinkIDPd.getReadMethod();
                                        try {
                                            linkVal = rMethod.invoke(arrChild, new Object[0]);
                                        }
                                        catch (Exception e13) {
                                            throw new DOMCodecException(e13);
                                        }
                                        se6.setAttribute(arrChLinkIDPd.getName(), linkVal.toString());
                                    } else {
                                        boolean appIfDefault = true;
                                        RemoveIfDefault riDAnnot2 = getMethod.getAnnotation(RemoveIfDefault.class);
                                        if (riDAnnot2 != null) {
                                            appIfDefault = false;
                                        }
                                        this.appendToDOM(d, se6, arrChild, appIfDefault);
                                    }
                                }
                            }
                            ++a;
                        }
                    }
                }
            } else if (List.class.isAssignableFrom(pClass)) {
                if (!(child == null || defChild != null && defChild.equals(child))) {
                    DOMRoot domRootAnno;
                    Type[] prtTypes;
                    collChLinkIDPd = null;
                    rt = pd5.getReadMethod().getGenericReturnType();
                    if (rt instanceof ParameterizedType && (prtTypes = (prt = (ParameterizedType)rt).getActualTypeArguments()) != null && prtTypes.length == 1 && (collParametrizedType = prtTypes[0]) instanceof Class && (domRootAnno = (collClass = (Class)collParametrizedType).getAnnotation(DOMRoot.class)) != null) {
                        BeanInfo collChBi = null;
                        try {
                            collChBi = Introspector.getBeanInfo(collClass);
                        }
                        catch (IntrospectionException e14) {
                            throw new DOMCodecException(e14);
                        }
                        PropertyDescriptor[] propertyDescriptorArray2 = arrChPds = collChBi.getPropertyDescriptors();
                        int n10 = arrChPds.length;
                        int linkIdanno22 = 0;
                        while (linkIdanno22 < n10) {
                            arrChPd = propertyDescriptorArray2[linkIdanno22];
                            arrChGetMethod = ((PropertyDescriptor)arrChPd).getReadMethod();
                            linkIdanno = arrChGetMethod.getAnnotation(LinkID.class);
                            if (linkIdanno != null) {
                                collChLinkIDPd = arrChPd;
                                break;
                            }
                            ++linkIdanno22;
                        }
                    }
                    collElementName = null;
                    Element collParent = e;
                    domCollElemAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                    if (domCollElemAnno != null) {
                        collElementName = domCollElemAnno.collectionElementName();
                        collParent = d.createElement(pdName);
                        e.appendChild(collParent);
                    } else {
                        collParent = e;
                    }
                    for (Object setChild : (List)child) {
                        Class<?> setClass = setChild.getClass();
                        if (String.class.equals(setClass)) {
                            se4 = d.createElement(pdName);
                            se4.appendChild(d.createTextNode((String)setChild));
                            collParent.appendChild(se4);
                            continue;
                        }
                        if (setClass.isPrimitive()) {
                            se4 = d.createElement(pdName);
                            se4.appendChild(d.createTextNode(setChild.toString()));
                            collParent.appendChild(se4);
                            continue;
                        }
                        if (Class.class.equals(setClass)) continue;
                        pdElementName = null;
                        if (propElemAnno != null) {
                            pdElementName = propElemAnno.name();
                        }
                        if (pdElementName == null) {
                            if (this.elementNameUpperCase) {
                                pdElementName = pdName.substring(0, 1).toUpperCase(Locale.ENGLISH);
                                pdElementName = pdElementName.concat(pd5.getName().substring(1));
                            } else {
                                pdElementName = new String(pdName);
                            }
                        }
                        se3 = null;
                        se3 = collElementName == null ? d.createElement(pdElementName) : d.createElement(collElementName);
                        collParent.appendChild(se3);
                        if (setChild == null) continue;
                        if (collChLinkIDPd != null) {
                            Object linkVal;
                            Method rMethod = ((PropertyDescriptor)collChLinkIDPd).getReadMethod();
                            try {
                                linkVal = rMethod.invoke(setChild, new Object[0]);
                            }
                            catch (Exception e15) {
                                throw new DOMCodecException(e15);
                            }
                            se3.setAttribute(((FeatureDescriptor)collChLinkIDPd).getName(), linkVal.toString());
                            continue;
                        }
                        boolean appIfDefault = true;
                        RemoveIfDefault riDAnnot3 = getMethod.getAnnotation(RemoveIfDefault.class);
                        if (riDAnnot3 != null) {
                            appIfDefault = false;
                        }
                        this.appendToDOM(d, se3, setChild, appIfDefault);
                    }
                }
            } else if (Set.class.isAssignableFrom(pClass)) {
                if (!(child == null || defChild != null && defChild.equals(child))) {
                    DOMRoot domRootAnno;
                    Type[] prtTypes;
                    collChLinkIDPd = null;
                    rt = pd5.getReadMethod().getGenericReturnType();
                    if (rt instanceof ParameterizedType && (prtTypes = (prt = (ParameterizedType)rt).getActualTypeArguments()) != null && prtTypes.length == 1 && (collParametrizedType = prtTypes[0]) instanceof Class && (domRootAnno = (collClass = (Class)collParametrizedType).getAnnotation(DOMRoot.class)) != null) {
                        BeanInfo collChBi = null;
                        try {
                            collChBi = Introspector.getBeanInfo(collClass);
                        }
                        catch (IntrospectionException e16) {
                            throw new DOMCodecException(e16);
                        }
                        e15 = arrChPds = collChBi.getPropertyDescriptors();
                        riDAnnot3 = arrChPds.length;
                        int appIfDefault = 0;
                        while (appIfDefault < riDAnnot3) {
                            arrChPd = e15[appIfDefault];
                            arrChGetMethod = ((PropertyDescriptor)arrChPd).getReadMethod();
                            linkIdanno = arrChGetMethod.getAnnotation(LinkID.class);
                            if (linkIdanno != null) {
                                collChLinkIDPd = arrChPd;
                                break;
                            }
                            ++appIfDefault;
                        }
                    }
                    collElementName = null;
                    Element collParent = e;
                    domCollElemAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                    if (domCollElemAnno != null) {
                        collElementName = domCollElemAnno.collectionElementName();
                        collParent = d.createElement(pdName);
                        e.appendChild(collParent);
                    } else {
                        collParent = e;
                    }
                    for (Object setChild : (Set)child) {
                        Class<?> setClass = setChild.getClass();
                        if (String.class.equals(setClass)) {
                            se4 = d.createElement(pdName);
                            se4.appendChild(d.createTextNode((String)setChild));
                            collParent.appendChild(se4);
                            continue;
                        }
                        if (setClass.isPrimitive()) {
                            se4 = d.createElement(pdName);
                            se4.appendChild(d.createTextNode(setChild.toString()));
                            collParent.appendChild(se4);
                            continue;
                        }
                        if (Class.class.equals(setClass)) continue;
                        pdElementName = null;
                        if (propElemAnno != null) {
                            pdElementName = propElemAnno.name();
                        }
                        if (pdElementName == null) {
                            if (this.elementNameUpperCase) {
                                pdElementName = pdName.substring(0, 1).toUpperCase(Locale.ENGLISH);
                                pdElementName = pdElementName.concat(pd5.getName().substring(1));
                            } else {
                                pdElementName = new String(pdName);
                            }
                        }
                        se3 = null;
                        se3 = collElementName == null ? d.createElement(pdElementName) : d.createElement(collElementName);
                        collParent.appendChild(se3);
                        if (setChild == null) continue;
                        if (collChLinkIDPd != null) {
                            Object linkVal;
                            Method rMethod = ((PropertyDescriptor)collChLinkIDPd).getReadMethod();
                            try {
                                linkVal = rMethod.invoke(setChild, new Object[0]);
                            }
                            catch (Exception e17) {
                                throw new DOMCodecException(e17);
                            }
                            se3.setAttribute(((FeatureDescriptor)collChLinkIDPd).getName(), linkVal.toString());
                            continue;
                        }
                        boolean appIfDefault = true;
                        RemoveIfDefault riDAnnot4 = getMethod.getAnnotation(RemoveIfDefault.class);
                        if (riDAnnot4 != null) {
                            appIfDefault = false;
                        }
                        this.appendToDOM(d, se3, setChild, appIfDefault);
                    }
                }
            } else if (Map.class.isAssignableFrom(pClass)) {
                if (!(child == null || defChild != null && defChild.equals(child))) {
                    Class keyClass;
                    DOMRoot domRootAnno;
                    Type keyParametrizedType;
                    Type[] prtTypes;
                    collChLinkIDPd = null;
                    rt = pd5.getReadMethod().getGenericReturnType();
                    if (rt instanceof ParameterizedType && (prtTypes = (prt = (ParameterizedType)rt).getActualTypeArguments()) != null && prtTypes.length == 2 && (keyParametrizedType = prtTypes[0]) instanceof Class && (domRootAnno = (keyClass = (Class)keyParametrizedType).getAnnotation(DOMRoot.class)) != null) {
                        BeanInfo collChBi = null;
                        try {
                            collChBi = Introspector.getBeanInfo(keyClass);
                        }
                        catch (IntrospectionException e18) {
                            throw new DOMCodecException(e18);
                        }
                        e15 = arrChPds = collChBi.getPropertyDescriptors();
                        riDAnnot3 = arrChPds.length;
                        int appIfDefault = 0;
                        while (appIfDefault < riDAnnot3) {
                            arrChPd = e15[appIfDefault];
                            arrChGetMethod = ((PropertyDescriptor)arrChPd).getReadMethod();
                            linkIdanno = arrChGetMethod.getAnnotation(LinkID.class);
                            if (linkIdanno != null) {
                                collChLinkIDPd = arrChPd;
                                break;
                            }
                            ++appIfDefault;
                        }
                    }
                    collElementName = null;
                    Element collParent = e;
                    domCollElemAnno = getMethod.getAnnotation(DOMCollectionElement.class);
                    if (domCollElemAnno != null) {
                        collElementName = domCollElemAnno.collectionElementName();
                        collParent = d.createElement(pdName);
                        e.appendChild(collParent);
                    } else {
                        collParent = e;
                    }
                    Element gse = d.createElement(pdName);
                    collParent.appendChild(gse);
                    Map m = (Map)child;
                    Set keySet = m.keySet();
                    for (Object keyChild : keySet) {
                        Object valChild;
                        Element se7 = d.createElement("entry");
                        gse.appendChild(se7);
                        if (keyChild != null) {
                            Node keyNode = se7.appendChild(d.createElement("key"));
                            Class<?> keyClass2 = keyChild.getClass();
                            if (String.class.equals(keyClass2)) {
                                keyNode.appendChild(d.createTextNode((String)keyChild));
                            } else if (keyClass2.isPrimitive()) {
                                keyNode.appendChild(d.createTextNode(keyChild.toString()));
                            } else if (!Class.class.equals(keyClass2)) {
                                throw new DOMCodecException("For maps type of key is restricted to String or primitive type!");
                            }
                        }
                        if ((valChild = m.get(keyChild)) == null) continue;
                        Node valNode = se7.appendChild(d.createElement("value"));
                        Class<?> valClass = valChild.getClass();
                        if (String.class.equals(valClass)) {
                            valNode.appendChild(d.createTextNode((String)valChild));
                            continue;
                        }
                        if (valClass.isPrimitive()) {
                            valNode.appendChild(d.createTextNode(valChild.toString()));
                            continue;
                        }
                        if (Class.class.equals(valClass)) continue;
                        throw new DOMCodecException("For maps type of kex is resctricteed to String or primitive type!");
                    }
                }
            } else if (pClass.isEnum()) {
                if (!(child == null || defChild != null && defChild.equals(child))) {
                    if (pdName.startsWith(attributePrefix)) {
                        attrName = pdName.substring(attributePrefix.length());
                        attrName = new String(String.valueOf(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + attrName.substring(1));
                        e.setAttribute(attrName, child.toString());
                    } else {
                        se2 = d.createElement(pdName);
                        se2.appendChild(d.createTextNode(child.toString()));
                        e.appendChild(se2);
                    }
                }
            } else if (pClass.equals(String.class)) {
                if (!(child == null || defChild != null && ((String)defChild).equals((String)child))) {
                    if (pdName.startsWith(attributePrefix)) {
                        attrName = pdName.substring(attributePrefix.length());
                        attrName = new String(String.valueOf(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + attrName.substring(1));
                        e.setAttribute(attrName, (String)child);
                    } else if (!pdName.equals(domTextNodePropertyName)) {
                        se2 = d.createElement(pdName);
                        se2.appendChild(d.createTextNode((String)child));
                        e.appendChild(se2);
                    }
                }
            } else if (Date.class.isAssignableFrom(pClass)) {
                if (!(child == null || defChild != null && ((Date)defChild).equals((Date)child))) {
                    RFC3339DateTimeFormat dateFormat = new RFC3339DateTimeFormat();
                    Temporal temporalAnno = getMethod.getAnnotation(Temporal.class);
                    if (temporalAnno != null && Temporal.Type.DATE.equals((Object)temporalAnno.type())) {
                        dateFormat.setTemporalType(RFC3339DateTimeFormat.TemporalType.DATE);
                    }
                    String formattedDateStr = dateFormat.format(child);
                    if (pdName.startsWith(attributePrefix)) {
                        String attrName2 = pdName.substring(attributePrefix.length());
                        attrName2 = new String(String.valueOf(attrName2.substring(0, 1).toLowerCase(Locale.ENGLISH)) + attrName2.substring(1));
                        e.setAttribute(attrName2, formattedDateStr);
                    } else {
                        Element se8 = d.createElement(pdName);
                        se8.appendChild(d.createTextNode(formattedDateStr));
                        e.appendChild(se8);
                    }
                }
            } else if (UUID.class.isAssignableFrom(pClass)) {
                if (!(child == null || defChild != null && ((UUID)defChild).equals((UUID)child))) {
                    String uuidStr = child.toString();
                    if (pdName.startsWith(attributePrefix)) {
                        String attrName3 = pdName.substring(attributePrefix.length());
                        attrName3 = new String(String.valueOf(attrName3.substring(0, 1).toLowerCase(Locale.ENGLISH)) + attrName3.substring(1));
                        e.setAttribute(attrName3, uuidStr);
                    } else {
                        se = d.createElement(pdName);
                        se.appendChild(d.createTextNode(uuidStr));
                        e.appendChild(se);
                    }
                }
            } else if (pClass.equals(Boolean.class)) {
                if (!(child == null || defChild != null && defChild.equals(child))) {
                    if (pdName.startsWith(attributePrefix)) {
                        attrName = pdName.substring(attributePrefix.length());
                        attrName = new String(String.valueOf(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + attrName.substring(1));
                        e.setAttribute(attrName, child.toString());
                    } else {
                        se2 = d.createElement(pdName);
                        se2.appendChild(d.createTextNode(child.toString()));
                        e.appendChild(se2);
                    }
                }
            } else if (pClass.isPrimitive() || Number.class.isAssignableFrom(pClass)) {
                if (!(child == null || defChild != null && defChild.equals(child))) {
                    if (pdName.startsWith(attributePrefix)) {
                        attrName = pdName.substring(attributePrefix.length());
                        attrName = new String(String.valueOf(attrName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + attrName.substring(1));
                        e.setAttribute(attrName, child.toString());
                    } else {
                        se2 = d.createElement(pdName);
                        se2.appendChild(d.createTextNode(child.toString()));
                        e.appendChild(se2);
                    }
                }
            } else if (!pClass.equals(Class.class) && child != null) {
                String pdElementName3 = null;
                if (propElemAnno != null) {
                    pdElementName3 = propElemAnno.name();
                }
                if (pdElementName3 == null) {
                    if (this.elementNameUpperCase) {
                        pdElementName3 = pdName.substring(0, 1).toUpperCase(Locale.ENGLISH);
                        pdElementName3 = pdElementName3.concat(pd5.getName().substring(1));
                    } else {
                        pdElementName3 = new String(pdName);
                    }
                }
                se = d.createElement(pdElementName3);
                e.appendChild(se);
                DOMRoot domRootAnno = pClass.getAnnotation(DOMRoot.class);
                if (domRootAnno != null) {
                    PropertyDescriptor[] chPds;
                    BeanInfo chBi = null;
                    try {
                        chBi = Introspector.getBeanInfo(pClass);
                    }
                    catch (IntrospectionException e19) {
                        throw new DOMCodecException(e19);
                    }
                    propertyDescriptorArray = chPds = chBi.getPropertyDescriptors();
                    int n11 = chPds.length;
                    int n12 = 0;
                    while (n12 < n11) {
                        PropertyDescriptor chPd = propertyDescriptorArray[n12];
                        Method chGetMethod = chPd.getReadMethod();
                        linkIdanno22 = chGetMethod.getAnnotation(LinkID.class);
                        if (linkIdanno22 != null) {
                            String linkIDpropname = chPd.getName();
                            try {
                                Object linkVal = chGetMethod.invoke(child, new Object[0]);
                                se.setAttribute(linkIDpropname, linkVal.toString());
                                break;
                            }
                            catch (Exception e110) {
                                throw new DOMCodecException(e110);
                            }
                        }
                        ++n12;
                    }
                } else {
                    this.appendToDOM(d, se, child);
                }
            }
            ++i;
        }
        if (!appendIfDefault) {
            NodeList nl = e.getChildNodes();
            boolean isEmpty = true;
            int l = 0;
            while (l < nl.getLength()) {
                Node n13 = nl.item(l);
                short nodeType = n13.getNodeType();
                if (nodeType == 2 || nodeType == 1 || nodeType == 3 || nodeType == 9) {
                    isEmpty = false;
                }
                ++l;
            }
            NamedNodeMap nMap = e.getAttributes();
            if (nMap.getLength() > 0) {
                isEmpty = false;
            }
            Node parent = e.getParentNode();
            if (isEmpty && parent.getNodeType() != 9) {
                parent.removeChild(e);
            }
        }
    }

    public static void main(String[] args) {
        File f = new File("test.xml");
        try {
            Package basePack = Class.forName("ipsk.beans.test.Root").getPackage();
            DOMCodec ph = new DOMCodec(basePack, false);
            DOMConverter dc = new DOMConverter();
            Root r = new Root();
            r.setRouting(new int[]{3, 5});
            r.setAttributeId("test");
            r.setAnnotatedTestAttribute("testAttribut Annotated");
            r.setName("Heyhey");
            HashSet<Child1> childrenSet = new HashSet<Child1>();
            Child1 childrenSet1 = new Child1();
            childrenSet1.setSampleRate(96000.0f);
            Child1 childrenSet2 = new Child1();
            childrenSet2.setSampleRate(24000.0f);
            childrenSet.add(childrenSet1);
            childrenSet.add(childrenSet2);
            r.setChildrenSet(childrenSet);
            String s1 = "Erstes String element";
            String s2 = "Zweites String element";
            String[] sd1 = new String[]{s1, s2};
            r.setMixerNames(sd1);
            r.setWeekDay(Root.WeekDays.WEDNESDAY);
            r.setTextContent("Dies ist Text!");
            Child1 c1 = new Child1();
            c1.setSampleSizes(new int[]{8, 16, 24, 32});
            c1.setAttributeSelection(Child1.Selection.GREEN);
            c1.setAttributeType("NORM");
            r.setChild(new Child1[]{c1});
            Child1 c3 = new Child1();
            c3.setSampleRate(128000.0f);
            r.setAnotherChild(new Child1[]{c3, c3});
            Document d = ph.createDocument(r);
            FileOutputStream fos = new FileOutputStream(f);
            dc.writeXML(d, new OutputStreamWriter(System.out));
            dc.writeXML(d, new OutputStreamWriter(fos));
            fos.close();
            Document d2 = dc.readXML(new FileInputStream(f));
            Root rr = (Root)ph.readDocument(d2);
            System.out.println(String.valueOf(rr.getName()) + " " + rr.getChild()[0].getAttributeType() + " " + rr.getTextContent());
            ph.createDocument(new SuperRoot());
        }
        catch (DOMCodecException e) {
            e.printStackTrace();
        }
        catch (DOMConverterException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

