/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import java.util.Vector;

public class VectorBuffer {
    protected long length = 0L;
    protected Vector<byte[]> buffers = new Vector();

    public byte[] get(int n) {
        return this.buffers.get(n);
    }

    public int size() {
        return this.buffers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte[] b) {
        VectorBuffer vectorBuffer = this;
        synchronized (vectorBuffer) {
            this.buffers.add(b);
            this.length += (long)b.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        VectorBuffer vectorBuffer = this;
        synchronized (vectorBuffer) {
            byte[] r = this.buffers.remove(n);
            this.length -= (long)r.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        VectorBuffer clone = new VectorBuffer();
        VectorBuffer vectorBuffer = this;
        synchronized (vectorBuffer) {
            clone.buffers = (Vector)this.buffers.clone();
            clone.length = this.length;
        }
        return clone;
    }

    public long getLength() {
        return this.length;
    }

    public Vector getBuffers() {
        return this.buffers;
    }

    public synchronized byte[] toByteArray() {
        if (this.length > Integer.MAX_VALUE) {
            return null;
        }
        byte[] buf = new byte[(int)this.length];
        int pos = 0;
        int i = 0;
        while (i < this.buffers.size()) {
            byte[] srcBuf = this.get(i);
            System.arraycopy(srcBuf, 0, buf, pos, srcBuf.length);
            pos += srcBuf.length;
            ++i;
        }
        return buf;
    }
}

