/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import ipsk.util.SystemHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JDialogPanel
extends JPanel
implements ActionListener {
    public static final boolean DEBUG = false;
    public static final int OK_OPTION = 0;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int CANCEL_OPTION = 2;
    private String frameTitle;
    private JPanel optionPanel;
    protected JButton okButton;
    protected JButton applyButton;
    protected JButton cancelButton;
    private Object value = JOptionPane.UNINITIALIZED_VALUE;
    protected JDialog dialog;
    protected Window owner;
    private Container contentPane;
    private Options options = Options.OK_CANCEL;
    private JButton helpButton;
    protected JMenuBar menuBar = null;
    private boolean resizable = true;
    private List<Image> iconImages;

    public List<Image> getIconImages() {
        return this.iconImages;
    }

    public void setIconImages(List<Image> iconImages) {
        this.iconImages = iconImages;
    }

    public JDialogPanel() {
        this(Options.OK_CANCEL);
    }

    public JDialogPanel(Options options) {
        this(options, false);
    }

    public JDialogPanel(Options options, boolean showHelpButton) {
        super(new BorderLayout());
        this.options = options;
        this.contentPane = new JPanel();
        this.add((Component)this.contentPane, "Center");
        this.optionPanel = new JPanel(new FlowLayout(4));
        if (showHelpButton) {
            this.helpButton = new JButton("?");
            this.optionPanel.add(this.helpButton);
        }
        if (options.equals((Object)Options.CANCEL) || options.equals((Object)Options.OK_CANCEL) || options.equals((Object)Options.OK_APPLY_CANCEL)) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            this.optionPanel.add(this.cancelButton);
        }
        if (options.equals((Object)Options.OK_APPLY_CANCEL)) {
            this.applyButton = new JButton("Apply");
            this.applyButton.addActionListener(this);
            this.optionPanel.add(this.applyButton);
        }
        if (options.equals((Object)Options.OK) || options.equals((Object)Options.OK_CANCEL) || options.equals((Object)Options.OK_APPLY_CANCEL)) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(this);
            this.optionPanel.add(this.okButton);
        }
        this.add((Component)this.optionPanel, "South");
    }

    private void _reset() {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(true);
        }
    }

    public JDialogPanel(String title) {
        this();
        this.setFrameTitle(title);
    }

    public JDialogPanel(Options options, String title) {
        this(options);
        this.setFrameTitle(title);
    }

    public Object getValue() {
        return this.value;
    }

    private JDialog createDialog(JDialog owner, boolean modal) {
        if (this.dialog == null || owner == null && this.owner != null || owner != null && !owner.equals(this.owner)) {
            this.dialog = new JDialog(owner, this.frameTitle, modal);
            if (this.iconImages != null) {
                this.dialog.setIconImages(this.iconImages);
            }
        }
        this._reset();
        this.owner = owner;
        if (this.menuBar != null) {
            this.dialog.setJMenuBar(this.menuBar);
        }
        this.dialog.getContentPane().add(this);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                JDialogPanel.this.doCancel();
            }
        });
        this.dialog.setResizable(this.resizable);
        return this.dialog;
    }

    public JDialog createDialog(JFrame owner) {
        return this.createDialog(owner, false);
    }

    public JDialog createDialog(JFrame owner, boolean modal) {
        if (this.dialog == null || owner == null && this.owner != null || owner != null && !owner.equals(this.owner)) {
            this.dialog = new JDialog(owner, this.frameTitle, modal);
            if (this.iconImages != null) {
                this.dialog.setIconImages(this.iconImages);
            }
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent arg0) {
                    JDialogPanel.this.doCancel();
                }
            });
        }
        this._reset();
        this.owner = owner;
        if (this.menuBar != null) {
            this.dialog.setJMenuBar(this.menuBar);
        }
        this.dialog.getContentPane().add(this);
        this.dialog.setResizable(this.resizable);
        return this.dialog;
    }

    public JDialog createDialog(JFrame owner, Dialog.ModalityType modalityType) {
        if (this.dialog == null || owner == null && this.owner != null || owner != null && !owner.equals(this.owner)) {
            this.dialog = new JDialog((Window)owner, this.frameTitle, modalityType);
            if (this.iconImages != null) {
                this.dialog.setIconImages(this.iconImages);
            }
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent arg0) {
                    JDialogPanel.this.doCancel();
                }
            });
        }
        this._reset();
        this.owner = owner;
        if (this.menuBar != null) {
            this.dialog.setJMenuBar(this.menuBar);
        }
        this.dialog.getContentPane().add(this);
        this.dialog.setResizable(this.resizable);
        return this.dialog;
    }

    public void showNonModalDialog(JDialog parent) {
        this.dialog = this.createDialog(parent, false);
        final JDialog fParent = parent;
        Runnable packAndShow = new Runnable(){

            @Override
            public void run() {
                JDialogPanel.this.dialog.pack();
                if (fParent != null) {
                    JDialogPanel.this.dialog.setLocationRelativeTo(fParent);
                }
                JDialogPanel.this.dialog.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(packAndShow);
    }

    public Object showDialog(JDialog parent) {
        this.dialog = this.createDialog(parent, true);
        JDialog fParent = parent;
        this.dialog.pack();
        if (fParent != null) {
            this.dialog.setLocationRelativeTo(fParent);
        }
        this.dialog.setVisible(true);
        return this.getValue();
    }

    public void showNonModalDialog(JFrame parent) {
        this.dialog = this.createDialog(parent, false);
        final JFrame fParent = parent;
        Runnable packAndShow = new Runnable(){

            @Override
            public void run() {
                JDialogPanel.this.dialog.pack();
                if (fParent != null) {
                    JDialogPanel.this.dialog.setLocationRelativeTo(fParent);
                }
                JDialogPanel.this.dialog.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(packAndShow);
    }

    public Object showDialog(JFrame parent) {
        this.dialog = this.createDialog(parent, true);
        JFrame fParent = parent;
        this.dialog.pack();
        if (fParent != null) {
            this.dialog.setLocationRelativeTo(fParent);
            fParent.toFront();
        }
        this.dialog.setVisible(true);
        return this.getValue();
    }

    public Object showDialog(JFrame parent, Dialog.ModalityType modalityType) {
        this.dialog = this.createDialog(parent, modalityType);
        JFrame fParent = parent;
        this.dialog.pack();
        if (fParent != null) {
            this.dialog.setLocationRelativeTo(fParent);
        }
        this.dialog.setVisible(true);
        return this.getValue();
    }

    public Object showDialog(Component parent) {
        do {
            if (parent instanceof JFrame) {
                return this.showDialog((JFrame)parent);
            }
            if (!(parent instanceof JDialog)) continue;
            return this.showDialog((JDialog)parent);
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    public void disposeDialog() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            SystemHelper.disposeWindowForReuse(this.dialog);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        if (src == this.okButton) {
            this.setValue(0);
            this.doOk();
        } else if (src == this.applyButton) {
            this.setValue(0);
            this.doApply();
        } else if (src == this.cancelButton) {
            this.doCancel();
        }
    }

    protected void doApply() {
        this.applyValues();
    }

    protected void doCancel() {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(false);
        }
        this.setValue(2);
        this.disposeDialog();
    }

    protected void doOk() {
        this.disposeDialog();
        this.applyValues();
    }

    protected void applyValues() {
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getFrameTitle() {
        return this.frameTitle;
    }

    public void setFrameTitle(String frameTitle) {
        this.frameTitle = frameTitle;
        if (this.dialog != null) {
            this.dialog.setTitle(frameTitle);
        }
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void setContentPane(Container contentPane) {
        this.remove(this.contentPane);
        this.contentPane = contentPane;
        this.add((Component)contentPane, "Center");
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setApplyingEnabled(boolean b) {
        if (this.okButton != null) {
            this.okButton.setEnabled(b);
        }
        if (this.applyButton != null) {
            this.applyButton.setEnabled(b);
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public static enum Options {
        NONE,
        OK,
        CANCEL,
        OK_CANCEL,
        OK_APPLY_CANCEL;

    }
}

