/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class JKeyChooser
extends JComboBox {
    public JKeyChooser(int keyCode) {
        this();
        this.setSelectedItemByCode(keyCode);
    }

    public JKeyChooser() {
        Field[] keFields = KeyEvent.class.getFields();
        int i = 0;
        while (i < keFields.length) {
            Class<?> type = keFields[i].getType();
            String name = keFields[i].getName();
            if (type.isPrimitive() && type.getName().equals("int") && name.startsWith("VK_")) {
                try {
                    int code = keFields[i].getInt(null);
                    if (code != 16 && code != 17 && code != 18) {
                        Key k = new Key(code);
                        this.addItem(k);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void setSelectedItemByCode(int keyCode) {
        Key k = new Key(keyCode);
        this.setSelectedItem(k);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] ch = this.getComponents();
        int i = 0;
        while (i < ch.length) {
            ch[i].setEnabled(enabled);
            ++i;
        }
    }

    public static void main(String[] args) {
        JKeyChooser kc = new JKeyChooser();
        JFrame f = new JFrame("KeyCooser");
        f.getContentPane().add(kc);
        f.pack();
        f.setVisible(true);
    }

    public class Key {
        private int code;

        public Key(int code) {
            this.code = code;
        }

        public String toString() {
            return KeyEvent.getKeyText(this.code);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return k.getCode() == this.code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

