/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.symbols;

import ipsk.swing.symbols.CharPane;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CharButton
extends JButton {
    private JPopupMenu popup;
    private CharPane charPane;

    public CharButton(String s) {
        this.setText(s);
        this.setBackground(new Color(255, 255, 255));
    }

    public CharButton(String s1, String s2) {
        this.setText(s1);
        this.setToolTipText(s2);
        this.setBackground(new Color(255, 255, 255));
        this.popup = new JPopupMenu();
    }

    public CharButton(String s, int i, ActionListener listener) {
        this.setText(s);
        this.setBackground(new Color(255, 255, 255));
        this.popup = new JPopupMenu();
        StringBuffer unicode = new StringBuffer("\\u");
        String hex = Integer.toHexString(i);
        if (hex.length() == 1) {
            unicode.append("000");
        } else if (hex.length() == 2) {
            unicode.append("00");
        } else if (hex.length() == 3) {
            unicode.append("0");
        }
        unicode.append(hex);
        JMenuItem insertChar = new JMenuItem(unicode.toString());
        insertChar.addActionListener(listener);
        this.popup.add(insertChar);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    public CharPane getCharPane() {
        return this.charPane;
    }

    public void setCharPane(CharPane charPane) {
        this.charPane = charPane;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                CharButton.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

