/*
 * Decompiled with CFR 0.152.
 */
package ips.dsp;

import ipsk.math.Complex;
import ipsk.math.DFT;
import ipsk.math.HammingWindow;

public class FIRFilterBuilder {
    public static double[] buildCoefficientsFromImpulsResponse(Complex[] impulseResponse) {
        Complex[] symImpulseResponse = new Complex[impulseResponse.length * 2];
        int i = 0;
        while (i < impulseResponse.length) {
            symImpulseResponse[i] = impulseResponse[i];
            symImpulseResponse[impulseResponse.length + i] = impulseResponse[impulseResponse.length - 1 - i];
            ++i;
        }
        Complex[] coeffComplex = DFT.processInvers(symImpulseResponse);
        double[] coeff = new double[coeffComplex.length];
        int i2 = 0;
        while (i2 < coeffComplex.length / 2) {
            double c;
            coeff[i2] = c = coeffComplex[coeffComplex.length / 2 + i2].real;
            ++i2;
        }
        i2 = 0;
        while (i2 < coeffComplex.length / 2) {
            double c2;
            coeff[coeffComplex.length / 2 + i2] = c2 = coeffComplex[i2].real;
            ++i2;
        }
        HammingWindow hw = new HammingWindow(coeff.length);
        int i3 = 0;
        while (i3 < coeff.length) {
            double scale = hw.getScale(i3);
            coeff[i3] = coeff[i3] * scale;
            ++i3;
        }
        return coeff;
    }
}

