/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.io;

import ipsk.io.FloatStream;
import ipsk.io.InterleavedFloatStream;
import java.io.IOException;
import java.util.Arrays;

public class InterleavedJoinFloatStream
implements InterleavedFloatStream {
    private static final int DEF_BUF_SIZE = 1024;
    private int bufSize = 1024;
    private FloatStream[] srcStreams;
    private Channel[] channels;

    public InterleavedJoinFloatStream(FloatStream[] srcStreams) {
        this.srcStreams = srcStreams;
        this.channels = new Channel[srcStreams.length];
        int ch = 0;
        while (ch < this.channels.length) {
            Channel c = this.channels[ch];
            c.srcStream = srcStreams[ch];
            c.buf = new double[this.bufSize];
            ++ch;
        }
    }

    @Override
    public int read(double[][] buf, int offset, int len) throws IOException {
        if (len > this.bufSize) {
            len = this.bufSize;
        }
        int minAvail = Integer.MAX_VALUE;
        int maxAvail = Integer.MIN_VALUE;
        boolean allEof = true;
        Channel[] channelArray = this.channels;
        int n = this.channels.length;
        int n2 = 0;
        while (n2 < n) {
            Channel c = channelArray[n2];
            if (!c.eof) {
                allEof = false;
            }
            if (c.avail < minAvail) {
                minAvail = c.avail;
            }
            if (c.avail > maxAvail) {
                maxAvail = c.avail;
            }
            ++n2;
        }
        if (allEof) {
            return -1;
        }
        if (minAvail == 0) {
            minAvail = Integer.MAX_VALUE;
            int ch = 0;
            while (ch < this.channels.length) {
                Channel c = this.channels[ch];
                if (c.eof) {
                    c.avail = this.bufSize;
                } else {
                    int os = c.avail;
                    int toRead = len - os;
                    if (toRead > 0) {
                        int r = c.srcStream.read(c.buf, os, toRead);
                        if (r == -1) {
                            c.eof = true;
                            Arrays.fill(c.buf, 0.0);
                            c.avail = this.bufSize;
                        } else {
                            c.avail += r;
                        }
                    }
                }
                if (c.avail < minAvail) {
                    minAvail = c.avail;
                }
                ++ch;
            }
        }
        return 0;
    }

    @Override
    public long skip(long skip) throws IOException {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        FloatStream[] floatStreamArray = this.srcStreams;
        int n = this.srcStreams.length;
        int n2 = 0;
        while (n2 < n) {
            FloatStream fs = floatStreamArray[n2];
            fs.close();
            ++n2;
        }
    }

    @Override
    public Integer getChannels() {
        return this.srcStreams.length;
    }

    public class Channel {
        FloatStream srcStream;
        int avail = 0;
        int bufPos = 0;
        double[] buf;
        boolean eof = false;
    }
}

