/*
 * Decompiled with CFR 0.152.
 */
package ipsk.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class CenterMiddleLayout
implements LayoutManager {
    private final boolean DEBUG = true;
    private boolean fallbackToMinSize;

    public CenterMiddleLayout() {
        this(true);
    }

    public CenterMiddleLayout(boolean fallbackToMinSize) {
        this.fallbackToMinSize = fallbackToMinSize;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            Component[] cs = parent.getComponents();
            int preferredWidth = 0;
            int preferredHeight = 0;
            int i = 0;
            while (i < cs.length) {
                Dimension d = cs[i].getPreferredSize();
                if (d != null) {
                    if (d.width > preferredWidth) {
                        preferredWidth = d.width;
                    }
                    if (d.height > preferredHeight) {
                        preferredHeight = d.height;
                    }
                }
                ++i;
            }
            preferredWidth += insets.left;
            preferredHeight += insets.top;
            return new Dimension(preferredWidth += insets.right, preferredHeight += insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            Component[] cs = parent.getComponents();
            int minimumWidth = 0;
            int minimumHeight = 0;
            int i = 0;
            while (i < cs.length) {
                Dimension d = cs[i].getMinimumSize();
                if (d != null) {
                    if (d.width > minimumWidth) {
                        minimumWidth = d.width;
                    }
                    if (d.height > minimumHeight) {
                        minimumHeight = d.height;
                    }
                }
                ++i;
            }
            minimumWidth += insets.left;
            minimumHeight += insets.top;
            return new Dimension(minimumWidth += insets.right, minimumHeight += insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int insetsX = insets.left + insets.right;
            int insetsY = insets.top + insets.bottom;
            int parentHeight = parent.getSize().height;
            int parentWidth = parent.getSize().width;
            Component[] cs = parent.getComponents();
            int i = 0;
            while (i < cs.length) {
                Component c = cs[i];
                Dimension pd = c.getPreferredSize();
                int pWidth = pd.width;
                int pHeight = pd.height;
                Dimension md = c.getMinimumSize();
                int mWidth = md.width;
                int mHeight = md.height;
                int cX = insets.left;
                int cWidth = pWidth;
                if (pWidth + insetsX <= parentWidth) {
                    cX = insets.left + (parentWidth - insetsX - pWidth) / 2;
                } else if (this.fallbackToMinSize && mWidth + insetsX <= parentWidth) {
                    cX = insets.left + (parentWidth - insetsX - mWidth) / 2;
                } else {
                    cWidth = parentWidth - insetsX;
                }
                int cY = insets.top;
                int cHeight = pHeight;
                if (pHeight + insetsY <= parentHeight) {
                    cY = insets.top + (parentHeight - insetsY - pHeight) / 2;
                } else if (this.fallbackToMinSize && mHeight + insetsX <= parentHeight) {
                    cY = insets.top + (parentHeight - insetsY - mHeight) / 2;
                } else {
                    cHeight = parentHeight - insetsY;
                }
                System.out.println("Parent size: " + parentWidth + "x" + parentHeight + " insets: " + insets);
                System.out.println("Component pref: " + pWidth + "x" + pHeight);
                System.out.println("Component min: " + mWidth + "x" + mHeight);
                System.out.println("Component bounds: " + cX + "," + cY + " " + cWidth + "x" + cHeight);
                c.setBounds(cX, cY, cWidth, cHeight);
                ++i;
            }
        }
    }
}

