/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileFilterByExtension
extends FileFilter {
    private String description;
    private String baseDescription;
    protected Extension[] exts;
    private String[] extensions;

    public FileFilterByExtension() {
    }

    public FileFilterByExtension(String baseDescription, String[] extensions) {
        this.baseDescription = baseDescription;
        this.extensions = extensions;
        this.update();
    }

    public void setBaseDescription(String baseDescription) {
        this.baseDescription = baseDescription;
        this.update();
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
        this.update();
    }

    public void update() {
        StringBuffer descriptionSB = new StringBuffer(this.baseDescription);
        int extCount = this.extensions.length;
        this.exts = new Extension[extCount];
        if (extCount > 0) {
            descriptionSB.append(" (");
        }
        int i = 0;
        while (i < extCount) {
            String ext;
            this.exts[i] = new Extension();
            this.exts[i].extension = ext = this.extensions[i];
            int extLen = ext.length();
            StringBuffer extMatch = new StringBuffer(".*\\.");
            int c = 0;
            while (c < extLen) {
                extMatch.append('[');
                char extC = ext.charAt(c);
                char lcExtC = Character.toLowerCase(extC);
                char ucExtC = Character.toUpperCase(extC);
                extMatch.append(lcExtC);
                extMatch.append(ucExtC);
                extMatch.append(']');
                ++c;
            }
            extMatch.append('$');
            this.exts[i].extensionMatch = extMatch.toString();
            descriptionSB.append("*.");
            descriptionSB.append(ext);
            if (i < extCount - 1) {
                descriptionSB.append(",");
            }
            ++i;
        }
        if (extCount > 0) {
            descriptionSB.append(")");
        }
        this.description = descriptionSB.toString();
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fName = f.getName();
        Extension[] extensionArray = this.exts;
        int n = this.exts.length;
        int n2 = 0;
        while (n2 < n) {
            Extension e = extensionArray[n2];
            if (fName.matches(e.extensionMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String extension(File f) {
        if (f.isDirectory()) {
            return null;
        }
        String fName = f.getName();
        Extension[] extensionArray = this.exts;
        int n = this.exts.length;
        int n2 = 0;
        while (n2 < n) {
            Extension e = extensionArray[n2];
            String extMatch = e.extensionMatch;
            if (fName.matches(extMatch)) {
                return e.extension;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public class Extension {
        public String extension;
        public String extensionMatch;
    }
}

