/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.FramedEditingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InterleaveEditInputStream
extends FramedEditingInputStream {
    private int frameOffset;
    private int frameRead;
    private byte[] isBuf;

    public InterleaveEditInputStream(InputStream is, int frameSize, int frameOffset, int frameRead) {
        super(is, frameSize);
        this.frameOffset = frameOffset;
        this.frameRead = frameRead;
        this.isBuf = new byte[0];
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        int read;
        if (len % this.frameRead > 0) {
            throw this.frameSizeException;
        }
        int framesToRead = len / this.frameRead;
        int bytesToRead = framesToRead * this.frameSize;
        if (this.isBuf.length < bytesToRead) {
            this.isBuf = new byte[bytesToRead];
        }
        if ((read = this.is.read(this.isBuf, 0, bytesToRead)) == -1) {
            return read;
        }
        if (read % this.frameSize > 0) {
            throw this.frameSizeException;
        }
        int framesRead = read / this.frameSize;
        int i = 0;
        while (i < framesRead) {
            System.arraycopy(this.isBuf, i * this.frameSize + this.frameOffset, buf, i * this.frameRead + offset, this.frameRead);
            ++i;
        }
        return framesRead * this.frameRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n % (long)this.frameRead > 0L) {
            throw this.frameSizeException;
        }
        long framesToSkip = n / (long)this.frameRead;
        long toSkip = framesToSkip * (long)this.frameSize;
        long skipped = this.is.skip(toSkip);
        if (skipped % (long)this.frameSize > 0L) {
            throw this.frameSizeException;
        }
        long ret = skipped / (long)this.frameSize * (long)this.frameRead;
        return ret;
    }
}

