/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class StreamCopy {
    public static int DEF_BUF_SIZE = 8192;
    public static Charset DEF_CHARSET = Charset.forName("UTF-8");

    public static void copy(File src, File dst) throws IOException {
        StreamCopy.copy(src, dst, false);
    }

    public static void copy(File src, File dst, boolean createParentDirectories) throws IOException {
        if (createParentDirectories) {
            File parentDir = dst.getParentFile();
            parentDir.mkdirs();
        }
        FileInputStream fis = new FileInputStream(src);
        FileOutputStream fos = new FileOutputStream(dst);
        StreamCopy.copy(fis, fos);
    }

    public static void copy(InputStream src, File dst, boolean createParentDirectories) throws IOException {
        if (createParentDirectories) {
            File parentDir = dst.getParentFile();
            parentDir.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(dst);
        StreamCopy.copy(src, fos);
    }

    public static void append(InputStream is, OutputStream os) throws IOException {
        int read = 0;
        byte[] buf = new byte[DEF_BUF_SIZE];
        try {
            while ((read = is.read(buf)) != -1) {
                if (read <= 0) continue;
                os.write(buf, 0, read);
            }
        }
        finally {
            is.close();
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        StreamCopy.copy(is, os, DEF_BUF_SIZE);
    }

    public static void copy(InputStream is, OutputStream os, boolean closeOutStream) throws IOException {
        StreamCopy.copy(is, os, closeOutStream, DEF_BUF_SIZE);
    }

    public static void copy(InputStream is, OutputStream os, int bufSize) throws IOException {
        StreamCopy.copy(is, os, true, bufSize);
    }

    public static void copy(InputStream is, OutputStream os, boolean closeOutStream, int bufSize) throws IOException {
        int read = 0;
        byte[] buf = new byte[bufSize];
        try {
            while ((read = is.read(buf)) != -1) {
                if (read <= 0) continue;
                os.write(buf, 0, read);
            }
        }
        finally {
            try {
                if (closeOutStream) {
                    os.close();
                }
            }
            finally {
                is.close();
            }
        }
    }

    public static void copyChars(Reader is, Writer os) throws IOException {
        int read = 0;
        char[] buf = new char[DEF_BUF_SIZE];
        try {
            while ((read = is.read(buf)) != -1) {
                if (read <= 0) continue;
                os.write(buf, 0, read);
            }
        }
        finally {
            try {
                os.close();
            }
            finally {
                is.close();
            }
        }
    }

    public static void writeUTF8TextFile(String text, File file) throws IOException {
        StreamCopy.writeTextFile(text, file, DEF_CHARSET);
    }

    public static void writeTextFile(String text, File file, Charset charset) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, charset);
        osw.write(text);
        osw.close();
    }

    public static String readTextStream(InputStream textStream, Charset charset) throws IOException {
        InputStreamReader isr = new InputStreamReader(textStream, charset);
        StringBuffer sb = new StringBuffer();
        int read = 0;
        char[] buf = new char[DEF_BUF_SIZE];
        try {
            while ((read = isr.read(buf)) != -1) {
                if (read <= 0) continue;
                sb.append(buf, 0, read);
            }
        }
        finally {
            isr.close();
        }
        return sb.toString();
    }

    public static String readTextFile(File textFile, Charset charset) throws IOException {
        FileInputStream fis = new FileInputStream(textFile);
        return StreamCopy.readTextStream(fis, charset);
    }

    public static void toSystemOut(InputStream is) throws IOException {
        StreamCopy.copy(is, (OutputStream)System.out, false);
    }

    public static void toSystemErr(InputStream is) throws IOException {
        StreamCopy.copy(is, (OutputStream)System.err, false);
    }
}

