/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math;

import ipsk.math.Complex;
import ipsk.math.DFTAlgorithm;

public class DFT
implements DFTAlgorithm {
    @Override
    public Complex[] process(Complex[] srcBuf) {
        int sizeN = srcBuf.length;
        Complex[] dstBuf = new Complex[sizeN];
        int k = 0;
        while (k < sizeN) {
            Complex cx = new Complex();
            double argTmp = Math.PI * -2 * (double)k;
            int j = 0;
            while (j < sizeN) {
                Complex aj = srcBuf[j];
                double arg = argTmp * (double)j / (double)sizeN;
                Complex ec = new Complex(Math.cos(arg), Math.sin(arg));
                cx = cx.add(ec.mult(aj));
                ++j;
            }
            dstBuf[k] = cx;
            ++k;
        }
        return dstBuf;
    }

    public static Complex[] processInvers(Complex[] srcBuf) {
        int sizeN = srcBuf.length;
        Complex[] dstBuf = new Complex[sizeN];
        int k = 0;
        while (k < sizeN) {
            Complex cx = new Complex();
            int j = 0;
            while (j < sizeN) {
                double arg = Math.PI * 2 * (double)k * (double)j / (double)sizeN;
                Complex aj = srcBuf[j];
                Complex ec = new Complex(Math.cos(arg), Math.sin(arg));
                cx = cx.add(ec.mult(aj));
                ++j;
            }
            dstBuf[k] = cx = cx.mult(1.0 / (double)sizeN);
            ++k;
        }
        return dstBuf;
    }

    @Override
    public Complex[] process(double[] srcBuf) {
        int sizeN = srcBuf.length;
        Complex[] dstBuf = new Complex[sizeN];
        int k = 0;
        while (k < sizeN) {
            Complex cx = new Complex();
            double tmpR = 0.0;
            double tmpI = 0.0;
            double argTmp = Math.PI * -2 * (double)k;
            int j = 0;
            while (j < sizeN) {
                double aj = srcBuf[j];
                double arg = argTmp * (double)j / (double)sizeN;
                tmpR += aj * Math.cos(arg);
                tmpI -= aj * Math.sin(arg);
                ++j;
            }
            cx.real = tmpR;
            cx.img = tmpI;
            dstBuf[k] = cx;
            ++k;
        }
        return dstBuf;
    }

    public Complex[] process(float[] srcBuf) {
        double[] srcDBuf = new double[srcBuf.length];
        int i = 0;
        while (i < srcBuf.length) {
            srcDBuf[i] = srcBuf[i];
            ++i;
        }
        return this.process(srcDBuf);
    }
}

