/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math;

import ipsk.math.Complex;
import ipsk.math.DFTAlgorithm;

public class FFT
implements DFTAlgorithm {
    @Override
    public Complex[] process(Complex[] srcBuf) {
        int sizeN = srcBuf.length;
        Complex[] dstBuf = new Complex[sizeN];
        if (sizeN == 1) {
            return srcBuf;
        }
        int halfN = sizeN / 2;
        Complex[] g = new Complex[halfN];
        Complex[] u = new Complex[halfN];
        int i = 0;
        while (i < halfN) {
            g[i] = srcBuf[i * 2];
            u[i] = srcBuf[i * 2 + 1];
            ++i;
        }
        Complex[] gBuf = this.process(g);
        Complex[] uBuf = this.process(u);
        int k = 0;
        while (k < halfN) {
            Complex cK2;
            Complex cK;
            double arc = Math.PI * -2 * (double)k / (double)sizeN;
            Complex tmpC = new Complex(Math.cos(arc), Math.sin(arc));
            tmpC = tmpC.mult(uBuf[k]);
            dstBuf[k] = cK = gBuf[k].add(tmpC);
            dstBuf[halfN + k] = cK2 = gBuf[k].sub(tmpC);
            ++k;
        }
        return dstBuf;
    }

    @Override
    public Complex[] process(double[] srcBuf) {
        int sizeN = srcBuf.length;
        Complex[] cSrcBuf = new Complex[sizeN];
        int i = 0;
        while (i < sizeN) {
            cSrcBuf[i] = new Complex(srcBuf[i], 0.0);
            ++i;
        }
        return this.process(cSrcBuf);
    }
}

