/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.awt.ProgressListener;
import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressEvent;
import ipsk.net.Download;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;

public class URLMultiContentLoader
extends ProgressWorker {
    public static final boolean DEBUG = false;
    public static final int DEBUG_TOTAL_MIN_MS = 10000;
    public final int DEFAULT_BUFFER_SIZE = 2048;
    private List<Download> downloadList;
    private byte[] buf = new byte[2048];
    private Long totalContentLength;
    private volatile Download currentDownload;

    public URLMultiContentLoader() {
        this(null, null);
    }

    public URLMultiContentLoader(String threadName) {
        this(null, threadName);
    }

    public URLMultiContentLoader(List<Download> downloads) {
        this(downloads, null);
    }

    public URLMultiContentLoader(List<Download> downloads, String threadName) {
        super(threadName);
        this.downloadList = downloads;
    }

    @Override
    public void open() throws WorkerException {
        String responseMsg = null;
        try {
            this.totalContentLength = new Long(0L);
            this.progressStatus.setMessage(new LocalizableMessage("Connecting ..."));
            this.fireProgressEvent();
            for (Download download : this.downloadList) {
                int contentLength;
                URL url = download.getSourceUrl();
                URLConnection urlConn = url.openConnection();
                if (urlConn != null) {
                    if (urlConn instanceof HttpURLConnection) {
                        int responseCode = ((HttpURLConnection)urlConn).getResponseCode();
                    } else if (urlConn instanceof HttpsURLConnection) {
                        int n = ((HttpsURLConnection)urlConn).getResponseCode();
                    }
                    if (urlConn instanceof HttpURLConnection) {
                        responseMsg = ((HttpURLConnection)urlConn).getResponseMessage();
                    } else if (urlConn instanceof HttpsURLConnection) {
                        responseMsg = ((HttpsURLConnection)urlConn).getResponseMessage();
                    }
                }
                if ((contentLength = urlConn.getContentLength()) == -1) {
                    String clStr = urlConn.getHeaderField("Content-Length");
                    if (clStr != null) {
                        try {
                            long parsedct = Long.parseLong(clStr);
                            this.totalContentLength = this.totalContentLength + parsedct;
                        }
                        catch (NumberFormatException nfe) {
                            this.totalContentLength = null;
                        }
                    } else {
                        this.totalContentLength = null;
                    }
                } else if (this.totalContentLength != null) {
                    this.totalContentLength = this.totalContentLength + (long)contentLength;
                }
                this.progressStatus.setMessage(new LocalizableMessage("Connected."));
            }
            this.fireProgressEvent();
        }
        catch (IOException e) {
            throw new WorkerException(responseMsg);
        }
        super.open();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doWork() throws WorkerException {
        String responseMsg = null;
        long transferred = 0L;
        for (Download download : this.downloadList) {
            URL url = download.getSourceUrl();
            OutputStream outputStream = download.getContentOutputStream();
            try {
                try {
                    URLConnection urlConn = url.openConnection();
                    if (urlConn != null) {
                        if (urlConn instanceof HttpURLConnection) {
                            responseMsg = ((HttpURLConnection)urlConn).getResponseMessage();
                        } else if (urlConn instanceof HttpsURLConnection) {
                            responseMsg = ((HttpsURLConnection)urlConn).getResponseMessage();
                        }
                    }
                    InputStream is = urlConn.getInputStream();
                    if (this.totalContentLength == null) {
                        this.progressStatus.setLength(ProgressStatus.LENGTH_UNKNOWN);
                        this.progressStatus.setIndeterminate(true);
                    } else {
                        this.progressStatus.setLength(this.totalContentLength);
                    }
                    this.fireProgressEvent();
                    int read = 0;
                    long startTime = System.currentTimeMillis();
                    this.progressStatus.setMessage(new LocalizableMessage("Download ..."));
                    while (!this.hasCancelRequest() && (read = is.read(this.buf)) != -1) {
                        outputStream.write(this.buf, 0, read);
                        transferred += (long)read;
                        if (this.totalContentLength == null) continue;
                        long perCentProgress = transferred * 100L / this.totalContentLength;
                        this.progressStatus.setProgress(transferred);
                        this.fireProgressEvent();
                    }
                }
                catch (IOException e) {
                    throw new WorkerException(e);
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        URL url = null;
        try {
            url = new URL("http://www.phonetik.uni-muenchen.de/~klausj/Trappa1.wav");
            File testFile = new File("test.wav");
            FileOutputStream fos = new FileOutputStream(testFile);
            URL url2 = new URL("http://ftp5.gwdg.de/pub/opensuse/distribution/12.1/iso/openSUSE-12.1-DVD-x86_64.iso");
            File testFile2 = new File("openSUSE-12.1-DVD-x86_64.iso");
            FileOutputStream fos2 = new FileOutputStream(testFile2);
            ArrayList<Download> downloads = new ArrayList<Download>();
            Download dl = new Download(url, fos);
            downloads.add(dl);
            Download dl2 = new Download(url2, fos2);
            downloads.add(dl2);
            URLMultiContentLoader cl = new URLMultiContentLoader(downloads, "Download");
            cl.addProgressListener(new ProgressListener(){

                @Override
                public void update(ProgressEvent progressEvent) {
                    System.out.println(progressEvent.getProgressStatus().getProgress());
                }
            });
            cl.open();
            cl.start();
            cl.close();
            cl.reset();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

