/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.net.UploadException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class Upload
implements Serializable {
    static final long serialVersionUID = -8377017842906075301L;
    public static final int IDLE = 0;
    public static final int UPLOADING = 1;
    public static final int CANCEL = 2;
    public static final int DONE = 3;
    public static final int FAILED = -1;
    public static final int DROPPED = -2;
    protected URL url = null;
    protected volatile transient int status = 0;
    protected String name;
    protected String comment;
    protected int failedUploadAttempts = 0;
    protected String mimeType = null;
    protected byte[] checksum = null;
    protected String checksumDigest = null;
    protected transient Long id = null;

    public Upload() {
    }

    public Upload(URL url) {
        this();
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int i) {
        this.status = i;
    }

    public abstract InputStream getInputStream() throws UploadException;

    public abstract long getLength();

    public abstract void delete();

    public String toString() {
        return new String(String.valueOf(this.getClass().getName()) + ": URL: " + this.getUrl() + ", Length: " + this.getLength() + ", State: " + this.getStatus());
    }

    public String getComment() {
        return this.comment;
    }

    public String getName() {
        return this.name;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void createChecksum(String digestName) throws UploadException {
        MessageDigest md;
        block18: {
            InputStream is = this.getInputStream();
            byte[] buffer = new byte[1024];
            try {
                md = MessageDigest.getInstance(digestName);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                throw new UploadException(e);
            }
            int read = 0;
            try {
                try {
                    do {
                        if ((read = is.read(buffer)) <= 0) continue;
                        md.update(buffer, 0, read);
                    } while (read >= 0);
                }
                catch (IOException iOException) {
                    if (is == null) break block18;
                    try {
                        is.close();
                        break block18;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new UploadException(e);
                    }
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new UploadException(e);
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new UploadException(e);
                }
            }
        }
        this.checksum = md.digest();
        this.checksumDigest = digestName;
    }

    public int hashCode() {
        int hash = 7;
        int urlHC = this.url == null ? 0 : this.url.hashCode();
        int nameHC = this.name == null ? 0 : this.name.hashCode();
        int commentHC = this.comment == null ? 0 : this.comment.hashCode();
        int mimeTypeHC = this.mimeType == null ? 0 : this.mimeType.hashCode();
        hash = 31 * hash + urlHC;
        hash = 31 * hash + nameHC;
        hash = 31 * hash + commentHC;
        hash = 31 * hash + mimeTypeHC;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Upload)) {
            return false;
        }
        Upload upload = (Upload)obj;
        if (!upload.getUrl().equals(this.url)) {
            return false;
        }
        if (this.name == null ? upload.getName() != null : !this.name.equals(upload.getName())) {
            return false;
        }
        if (this.comment == null ? upload.getComment() != null : !this.comment.equals(upload.getComment())) {
            return false;
        }
        return !(this.mimeType == null ? upload.getMimeType() != null : !this.mimeType.equals(upload.getMimeType()));
    }

    public int getFailedUploadAttempts() {
        return this.failedUploadAttempts;
    }

    public void setFailedUploadAttempts(int failedUploadAttempts) {
        this.failedUploadAttempts = failedUploadAttempts;
    }

    public void incFailedAttemptsCounter() {
        ++this.failedUploadAttempts;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public String getChecksumDigest() {
        return this.checksumDigest;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

