/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net.http;

import ipsk.text.StringTokenizer;
import ipsk.text.quoting.QuoteParser;
import ipsk.text.quoting.TextPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ContentType {
    private String mediaType;
    private Map<String, List<String>> parameters;

    public ContentType(String mediaType, Map<String, List<String>> parameters) {
        this.mediaType = mediaType;
        this.parameters = parameters;
    }

    public static ContentType parseHttpString(String httpContentTypeString) {
        List<TextPart> textPartList = QuoteParser.parseText(httpContentTypeString, '\"', Character.valueOf('\\'), false);
        String[] fields = StringTokenizer.split(textPartList, ';', true);
        String mediaType = fields[0];
        HashMap<String, List<String>> pMap = new HashMap<String, List<String>>();
        int i = 1;
        while (i < fields.length) {
            String field = fields[i];
            int equInd = field.indexOf(61);
            if (equInd > 0) {
                String key = field.substring(0, equInd).trim().toLowerCase(Locale.US);
                String val = field.substring(equInd + 1).trim();
                List<String> paramVals = pMap.get(key);
                if (paramVals == null) {
                    paramVals = new ArrayList<String>();
                    pMap.put(key, paramVals);
                }
                paramVals.add(val);
            }
            ++i;
        }
        ContentType ct = new ContentType(mediaType, pMap);
        return ct;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public String getCharsetParameter() {
        String charset = null;
        List<String> charsetparamList = this.parameters.get("charset");
        if (charsetparamList != null && charsetparamList.size() == 1) {
            charset = charsetparamList.get(0);
        }
        return charset;
    }
}

