/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import ipsk.text.ParserException;
import ipsk.text.Version;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class VersionPattern {
    private DigitPattern[] versionPattern;

    public VersionPattern(DigitPattern[] versionPattern) {
        this.versionPattern = versionPattern;
    }

    public static VersionPattern parseString(String versionString) throws ParserException {
        String[] numberStrs = versionString.split("[.]");
        if (numberStrs == null || numberStrs.length == 0) {
            throw new ParserException("Could not parse version string");
        }
        DigitPattern[] vns = new DigitPattern[numberStrs.length];
        int i = 0;
        while (i < numberStrs.length) {
            String numberStr = numberStrs[i];
            DigitPattern dp = null;
            if (numberStr.equals("*") || numberStr.equals("x")) {
                dp = new DigitPattern();
            } else {
                try {
                    int vn = Integer.parseInt(numberStrs[i]);
                    dp = new DigitPattern(vn);
                }
                catch (NumberFormatException nfe) {
                    throw new ParserException(nfe);
                }
            }
            vns[i] = dp;
            ++i;
        }
        VersionPattern v = new VersionPattern(vns);
        return v;
    }

    public boolean matches(Version v) {
        int vpLen;
        int[] vds = v.getVersion();
        int vdsLen = vds.length;
        if (vdsLen > (vpLen = this.versionPattern.length)) {
            return false;
        }
        int i = 0;
        while (i < vds.length) {
            DigitPattern dp = this.versionPattern[i];
            int vd = vds[i];
            if (!dp.matches(vd)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.versionPattern != null && this.versionPattern.length > 0) {
            int i = 0;
            while (i < this.versionPattern.length - 1) {
                sb.append(this.versionPattern[i]);
                sb.append(".");
                ++i;
            }
            sb.append(this.versionPattern[this.versionPattern.length - 1]);
        }
        return sb.toString();
    }

    public static class DigitPattern {
        private boolean wildcard;
        private Integer digit;

        public DigitPattern(int digit) {
            this.wildcard = false;
            this.digit = digit;
        }

        public DigitPattern() {
            this.wildcard = true;
            this.digit = null;
        }

        public boolean matches(int digit) {
            return this.wildcard || this.digit != null && this.digit.equals(digit);
        }

        public String toString() {
            if (this.wildcard) {
                return "*";
            }
            return this.digit.toString();
        }
    }

    public static class VersionPatternXMLAdapter
    extends XmlAdapter<String, VersionPattern> {
        public String marshal(VersionPattern vp) throws Exception {
            return vp.toString();
        }

        public VersionPattern unmarshal(String v) throws Exception {
            return VersionPattern.parseString(v);
        }
    }
}

