/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.services;

import ipsk.util.services.ManifestServiceDescriptor;
import ipsk.util.services.PackageServiceDescriptor;
import ipsk.util.services.ServiceDescriptor;
import ipsk.util.services.ServiceDescriptorProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Manifest;
import javax.sound.sampled.spi.FormatConversionProvider;

public class ServicesInspector<S> {
    private static final boolean DEBUG = false;
    private static final String META_PATH = "META-INF";
    private static final String MANIFEST_PATH = "META-INFMANIFEST.MF";
    private static final String META_SERVICES_PATH = "META-INF/services/";
    private Class<S> serviceClass;
    public static final boolean DEFAULT_UNIQUE = true;
    private boolean unique = true;

    public ServicesInspector(Class<S> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public ServicesInspector() {
        this(null);
    }

    protected List<String> readServiceImplementorClassnames(InputStream is) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        InputStreamReader isReader = new InputStreamReader(is);
        String l = null;
        try (LineNumberReader lnr = new LineNumberReader(isReader);){
            while ((l = lnr.readLine()) != null) {
                int commentIndex = l.indexOf("#");
                if (commentIndex >= 0) {
                    l = l.substring(0, commentIndex);
                }
                if ((l = l.trim()).equals("")) continue;
                list.add(l);
            }
        }
        return list;
    }

    public List<ServiceDescriptor> getServiceDescriptors() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<ServiceDescriptor> contextList = this.getServiceDescriptors(this.serviceClass, ServiceDescriptor.class, cl, false);
        return contextList;
    }

    public List<ServiceDescriptor> getServiceDescriptors(Class<S> providerClass, Class<? extends ServiceDescriptor> serviceDescriptorClass, ClassLoader cl, boolean loadImplementationClass) throws IOException {
        String providerClassname = providerClass.getName();
        ArrayList<ServiceDescriptor> serviceDescriptorList = new ArrayList<ServiceDescriptor>();
        HashSet<String> foundImplClassnames = new HashSet<String>();
        Enumeration<URL> psdUrls = cl.getResources(META_SERVICES_PATH + serviceDescriptorClass.getName());
        while (psdUrls.hasMoreElements()) {
            URL sdUrl = psdUrls.nextElement();
            InputStream sdIs = sdUrl.openStream();
            List<String> implClassList = this.readServiceImplementorClassnames(sdIs);
            for (String implClassname : implClassList) {
                Class<?> sdClass = null;
                try {
                    ServiceDescriptor sd;
                    String sdServiceClassName;
                    Object sdServiceClass;
                    sdClass = Class.forName(implClassname);
                    if (!serviceDescriptorClass.isAssignableFrom(sdClass) || !providerClass.equals(sdServiceClass = Class.forName(sdServiceClassName = (sd = (ServiceDescriptor)sdClass.newInstance()).getServiceImplementationClassname())) || (foundImplClassnames.contains(implClassname) || serviceDescriptorList.contains(sd)) && this.unique) continue;
                    serviceDescriptorList.add(sd);
                    foundImplClassnames.add(implClassname);
                }
                catch (ClassNotFoundException sd) {
                }
                catch (InstantiationException sd) {
                }
                catch (IllegalAccessException sd) {
                }
                catch (LinkageError sd) {
                    // empty catch block
                }
            }
        }
        Enumeration<URL> sdUrls = cl.getResources(META_SERVICES_PATH + ServiceDescriptor.class.getName());
        while (sdUrls.hasMoreElements()) {
            URL sdUrl = sdUrls.nextElement();
            String sdPath = sdUrl.getPath();
            int jarSepPos = sdPath.indexOf("!");
            URL jarUrl = null;
            if (jarSepPos > 0) {
                String jarPath = sdPath.substring(0, jarSepPos);
                jarUrl = new URL(sdUrl.getProtocol(), sdUrl.getHost(), jarPath);
            }
            InputStream sdIs = sdUrl.openStream();
            List<String> implClassList = this.readServiceImplementorClassnames(sdIs);
            for (String implClassname : implClassList) {
                Class<?> sdClass = null;
                try {
                    ServiceDescriptor sd;
                    String sdServiceClassName;
                    Class<?> sdServiceClass;
                    sdClass = Class.forName(implClassname);
                    if (!serviceDescriptorClass.isAssignableFrom(sdClass) || !providerClass.equals(sdServiceClass = Class.forName(sdServiceClassName = (sd = (ServiceDescriptor)sdClass.newInstance()).getServiceImplementationClassname())) || (foundImplClassnames.contains(implClassname) || serviceDescriptorList.contains(sd)) && this.unique) continue;
                    serviceDescriptorList.add(sd);
                    foundImplClassnames.add(implClassname);
                }
                catch (ClassNotFoundException sd) {
                }
                catch (InstantiationException sd) {
                }
                catch (IllegalAccessException sd) {
                }
                catch (LinkageError sd) {
                    // empty catch block
                }
            }
        }
        Enumeration<URL> urls = cl.getResources(META_SERVICES_PATH + providerClassname);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            List<String> implClassList = this.readServiceImplementorClassnames(is);
            for (String implClassname : implClassList) {
                PackageServiceDescriptor serviceDescriptor = null;
                if (loadImplementationClass) {
                    Class<?> sImplClass = null;
                    try {
                        Class<?>[] sImplClassIfs;
                        sImplClass = Class.forName(implClassname);
                        Class<?>[] classArray = sImplClassIfs = sImplClass.getInterfaces();
                        int n = sImplClassIfs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block31: {
                                Class<?> sImplClassIf = classArray[n2];
                                if (ServiceDescriptorProvider.class.equals(sImplClassIf)) {
                                    ServiceDescriptorProvider sdP = null;
                                    try {
                                        sdP = (ServiceDescriptorProvider)sImplClass.newInstance();
                                        Object sd = sdP.getServiceDescriptor();
                                        if (!sd.getClass().isAssignableFrom(serviceDescriptorClass)) break block31;
                                        serviceDescriptor = sd;
                                    }
                                    catch (InstantiationException e) {
                                        e.printStackTrace();
                                        break;
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                        break;
                                    }
                                }
                            }
                            ++n2;
                        }
                        if (serviceDescriptor == null && ServiceDescriptor.class.equals(serviceDescriptorClass)) {
                            Package p = sImplClass.getPackage();
                            serviceDescriptor = new PackageServiceDescriptor(this.serviceClass, implClassname, p);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                } else if (ServiceDescriptor.class.equals(serviceDescriptorClass)) {
                    URL manifestUrl = new URL(url, "../MANIFEST.MF");
                    cl.getResourceAsStream(manifestUrl.toString());
                    InputStream mfStream = null;
                    try {
                        mfStream = manifestUrl.openStream();
                    }
                    catch (IOException p) {
                        // empty catch block
                    }
                    Manifest mf = null;
                    if (mfStream != null) {
                        mf = new Manifest(mfStream);
                    }
                    serviceDescriptor = new ManifestServiceDescriptor(this.serviceClass, implClassname, mf);
                }
                if ((serviceDescriptor == null || !serviceDescriptorClass.isAssignableFrom(serviceDescriptor.getClass()) || foundImplClassnames.contains(implClassname) || serviceDescriptorList.contains(serviceDescriptor)) && this.unique) continue;
                serviceDescriptorList.add(serviceDescriptor);
                foundImplClassnames.add(implClassname);
            }
        }
        return serviceDescriptorList;
    }

    public List<String> getServiceImplementorClassnames() throws IOException {
        return this.getServiceImplementorClassnames(this.serviceClass.getName());
    }

    private List<String> getServiceImplementorClassnames(String providerClassname, ClassLoader cl) throws IOException {
        ArrayList<String> implClassnameList = new ArrayList<String>();
        Enumeration<URL> urls = cl.getResources(META_SERVICES_PATH + providerClassname);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            List<String> implClassList = this.readServiceImplementorClassnames(is);
            for (String implClassname : implClassList) {
                if (implClassnameList.contains(implClassname) && this.unique) continue;
                implClassnameList.add(implClassname);
            }
        }
        return implClassnameList;
    }

    protected List<String> getServiceImplementorClassnames(String providerClassname) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<String> contextList = this.getServiceImplementorClassnames(providerClassname, cl);
        return contextList;
    }

    public List<Class<? extends S>> getServiceImplementorClasses() throws IOException, ClassNotFoundException {
        return this.getServiceImplementorClasses(false);
    }

    public List<Class<? extends S>> getServiceImplementorClasses(boolean ignoreErrors) throws IOException, ClassNotFoundException {
        ArrayList<Class<S>> classList = new ArrayList<Class<S>>();
        List<String> classNamesList = this.getServiceImplementorClassnames(this.serviceClass.getName());
        for (String s : classNamesList) {
            Class<?> ic;
            if (ignoreErrors) {
                try {
                    ic = Class.forName(s);
                    classList.add(ic);
                }
                catch (Error ic2) {}
                continue;
            }
            ic = Class.forName(s);
            classList.add(ic);
        }
        return classList;
    }

    private List<Class<? extends S>> getServiceImplementorClasses(String providerClassName) throws IOException, ClassNotFoundException {
        ArrayList<Class<S>> classList = new ArrayList<Class<S>>();
        List<String> classNamesList = this.getServiceImplementorClassnames(providerClassName);
        for (String s : classNamesList) {
            Class<?> ic = Class.forName(s);
            classList.add(ic);
        }
        return classList;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public static void main(String[] args) {
        Class<FormatConversionProvider> EXAMPLE_SERVICE = FormatConversionProvider.class;
        ServicesInspector<FormatConversionProvider> pluginManager = new ServicesInspector<FormatConversionProvider>(FormatConversionProvider.class);
        System.out.println("Example: List of service providers for " + EXAMPLE_SERVICE + "\n");
    }
}

