/*
 * Decompiled with CFR 0.152.
 */
package ips.dsp;

public class AutoCorrelator {
    public static AutoCorrelationResult autoCorrelate(double[] buf, int offset, int corrLen, int corrStart, int corrEnd) {
        int corrIvLen = corrEnd - corrStart;
        double sum0 = 0.0;
        int pos = offset;
        int i = 0;
        while (i < corrLen) {
            sum0 += buf[pos] * buf[pos];
            ++pos;
            ++i;
        }
        double max = 0.0;
        int maxPosOff = 0;
        int p = 0;
        while (p < corrIvLen) {
            double val = 0.0;
            pos = offset;
            int pos2 = offset + corrStart + p;
            int i2 = 0;
            while (i2 < corrLen) {
                val += buf[pos] * buf[pos2];
                ++pos;
                ++pos2;
                ++i2;
            }
            if (val > max) {
                max = val;
                maxPosOff = p;
            }
            ++p;
        }
        AutoCorrelationResult rs = new AutoCorrelationResult(sum0 / (double)corrLen, maxPosOff, max / (double)corrLen);
        return rs;
    }

    public static double[] autoCorrelate(double[] buf) {
        int corrLen = buf.length;
        double[] corr = new double[corrLen];
        int p = 0;
        while (p < corrLen) {
            double val = 0.0;
            int i = 0;
            while (i < corrLen) {
                int pos = p + i;
                if (pos < corrLen) {
                    val += buf[pos] * buf[i];
                }
                ++i;
            }
            corr[p] = val;
            ++p;
        }
        return corr;
    }

    public static void main(String[] args) {
        double[] fcs = AutoCorrelator.autoCorrelate(new double[]{2.0, 4.0, 0.3});
        int i = 0;
        while (i < fcs.length) {
            System.out.println(fcs[i]);
            ++i;
        }
    }

    public static class AutoCorrelationResult {
        private double energy;
        private int positionMax;
        private double corrEnergyMax;

        public double getEnergy() {
            return this.energy;
        }

        public int getPositionMax() {
            return this.positionMax;
        }

        public double getCorrEnergyMax() {
            return this.corrEnergyMax;
        }

        public double correlation() {
            return this.corrEnergyMax / this.energy;
        }

        public AutoCorrelationResult(double energy, int positionMax, double energyMax) {
            this.energy = energy;
            this.positionMax = positionMax;
            this.corrEnergyMax = energyMax;
        }
    }
}

