/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net.cookie;

import ipsk.net.cookie.SimpleCookie;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SessionCookieHandler
extends CookieHandler {
    public static final String KEY_JSESSIONID = "JSESSIONID";
    private SimpleCookie sessionCookie;
    private boolean acceptNewCookies = false;

    public SessionCookieHandler(String sessionCookieStr) {
        this.sessionCookie = new SimpleCookie(sessionCookieStr);
    }

    @Override
    public Map<String, List<String>> get(URI arg0, Map<String, List<String>> map) throws IOException {
        HashMap<String, List<Object>> retMap = new HashMap<String, List<Object>>();
        URI cookieUri = null;
        boolean uriMatch = false;
        try {
            String pathProp = this.sessionCookie.getProperty("path");
            if (pathProp != null) {
                cookieUri = new URI(pathProp);
                URI serverAuthReq = arg0.normalize();
                URI serverAuthSessionCookie = cookieUri.normalize();
                uriMatch = serverAuthReq.getScheme().equals(serverAuthSessionCookie.getScheme()) && serverAuthReq.getHost().equals(serverAuthSessionCookie.getHost()) && serverAuthReq.getPort() == serverAuthSessionCookie.getPort() && serverAuthReq.getPath().startsWith(serverAuthSessionCookie.getPath());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            uriMatch = false;
        }
        if (!uriMatch) {
            return map;
        }
        boolean hasCookieMap = false;
        ArrayList<String> newCookieEntries = new ArrayList<String>();
        for (String key : map.keySet()) {
            if (key.equalsIgnoreCase("Cookie")) {
                hasCookieMap = true;
                List<String> cookieEntries = map.get(key);
                for (String cookie : cookieEntries) {
                    boolean isJsessionId = false;
                    StringTokenizer cookieTokenizer = new StringTokenizer(cookie, ";");
                    while (cookieTokenizer.hasMoreElements()) {
                        String cookieProp = cookieTokenizer.nextToken().trim();
                        String propKey = cookieProp.substring(0, cookieProp.indexOf(61));
                        if (!propKey.equalsIgnoreCase(KEY_JSESSIONID)) continue;
                        isJsessionId = true;
                    }
                    if (isJsessionId) continue;
                    newCookieEntries.add(cookie);
                }
                newCookieEntries.add(this.sessionCookie.toString());
                retMap.put(key, newCookieEntries);
            } else {
                retMap.put(key, map.get(key));
            }
            if (hasCookieMap) continue;
            newCookieEntries.add(this.sessionCookie.toString());
            retMap.put("Cookie", newCookieEntries);
        }
        return Collections.unmodifiableMap(retMap);
    }

    @Override
    public void put(URI arg0, Map<String, List<String>> cookies) throws IOException {
        if (!this.acceptNewCookies) {
            return;
        }
    }

    public boolean isAcceptNewCookies() {
        return this.acceptNewCookies;
    }

    public void setAcceptNewCookies(boolean acceptNewCookies) {
        this.acceptNewCookies = acceptNewCookies;
    }
}

