/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.text;

import ipsk.swing.CopyAction;
import ipsk.swing.CutAction;
import ipsk.swing.PasteAction;
import ipsk.swing.RedoAction;
import ipsk.swing.SelectAllAction;
import ipsk.swing.UndoAction;
import ipsk.swing.action.EditActions;
import ipsk.swing.action.EditActionsListener;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class EditorKitMenu
implements CaretListener,
MouseListener,
FlavorListener,
FocusListener,
UndoableEditListener {
    private JTextComponent textComponent;
    private ArrayList<JMenuItem> menuItems = new ArrayList();
    private Action[] actions;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private JPopupMenu popupMenu;
    private boolean popupMenuActiv = true;
    private Clipboard clipboard;
    private Vector<EditActionsListener> editActionsListenerList;
    private EditActions editActions;
    private UndoManager undoManager = new UndoManager();

    public EditorKitMenu(JTextComponent textComponent, EditActionsListener editActionsListener) {
        this(textComponent);
        this.addEditActionListener(editActionsListener);
    }

    public EditorKitMenu(JTextComponent textComponent) {
        this(textComponent, true);
    }

    public EditorKitMenu(JTextComponent textComponent, boolean editable) {
        this.textComponent = textComponent;
        try {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (SecurityException se) {
            this.clipboard = null;
        }
        if (this.clipboard != null) {
            this.clipboard.addFlavorListener(this);
        }
        this.actions = textComponent.getActions();
        InputMap iMap = textComponent.getInputMap();
        ActionMap aMap = textComponent.getActionMap();
        textComponent.addCaretListener(this);
        final UndoManager um = this.undoManager;
        this.undoAction = new UndoAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                um.undo();
                EditorKitMenu.this.updateActions();
            }
        };
        iMap.put(UndoAction.ACCELERATOR_VAL, UndoAction.NAME);
        aMap.put(UndoAction.NAME, this.undoAction);
        this.redoAction = new RedoAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                um.redo();
                EditorKitMenu.this.updateActions();
            }
        };
        iMap.put(RedoAction.ACCELERATOR_VAL, RedoAction.NAME);
        aMap.put(RedoAction.NAME, this.redoAction);
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        Document d = textComponent.getDocument();
        d.addUndoableEditListener(this);
        Action[] actionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action a = actionArray[n2];
            if (a.getValue("Name").equals("cut-to-clipboard")) {
                final Action aCut = a;
                this.cutAction = new CutAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        aCut.actionPerformed(e);
                    }
                };
                if (editable) {
                    this.menuItems.add(new JMenuItem(this.cutAction));
                }
            } else if (a.getValue("Name").equals("copy-to-clipboard")) {
                final Action aCopy = a;
                this.copyAction = new CopyAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        aCopy.actionPerformed(e);
                    }
                };
                this.menuItems.add(new JMenuItem(this.copyAction));
            } else if (a.getValue("Name").equals("paste-from-clipboard")) {
                final Action aPaste = a;
                this.pasteAction = new PasteAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        aPaste.actionPerformed(e);
                    }
                };
                this.pasteAction.setEnabled(false);
                if (editable) {
                    this.menuItems.add(new JMenuItem(this.pasteAction));
                }
            } else if (a.getValue("Name").equals("select-all")) {
                final Action aSelectAll = a;
                SelectAllAction selectAllAction = new SelectAllAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        aSelectAll.actionPerformed(e);
                    }
                };
                this.menuItems.add(new JMenuItem(selectAllAction));
            }
            ++n2;
        }
        if (editable) {
            this.menuItems.add(new JMenuItem(this.undoAction));
            this.menuItems.add(new JMenuItem(this.redoAction));
        }
        this.popupMenu = this.createJPopupMenu();
        this.editActionsListenerList = new Vector();
        this.editActions = new EditActions("Editor kit menu of " + textComponent.getClass().getName(), this.cutAction, this.copyAction, this.pasteAction, this.undoAction, this.redoAction);
        textComponent.addFocusListener(this);
        this.updateActions();
        this.setPopupMenuActiv(true);
    }

    public JPopupMenu createJPopupMenu() {
        JPopupMenu popMenu = new JPopupMenu();
        for (JMenuItem mi : this.menuItems) {
            popMenu.add(mi);
        }
        return popMenu;
    }

    public boolean isPopupMenuActiv() {
        return this.popupMenuActiv;
    }

    public void setPopupMenuActiv(boolean popupMenuActiv) {
        this.popupMenuActiv = popupMenuActiv;
        if (this.popupMenuActiv) {
            this.textComponent.addMouseListener(this);
        } else {
            this.textComponent.removeMouseListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        System.out.println(evt);
    }

    private void updateActions() {
        if (this.clipboard != null) {
            boolean clipBoardAvail = false;
            try {
                clipBoardAvail = this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            String selText = this.textComponent.getSelectedText();
            if (selText != null) {
                if (this.cutAction != null) {
                    this.cutAction.setEnabled(true);
                }
                if (this.copyAction != null) {
                    this.copyAction.setEnabled(true);
                }
            } else {
                if (this.cutAction != null) {
                    this.cutAction.setEnabled(false);
                }
                if (this.copyAction != null) {
                    this.copyAction.setEnabled(false);
                }
            }
            if (clipBoardAvail) {
                if (this.pasteAction != null) {
                    this.pasteAction.setEnabled(true);
                }
            } else if (this.pasteAction != null) {
                this.pasteAction.setEnabled(false);
            }
        }
        this.undoAction.setEnabled(this.undoManager.canUndo());
        this.undoAction.putValue("Name", this.undoManager.getUndoPresentationName());
        this.redoAction.setEnabled(this.undoManager.canRedo());
        this.redoAction.putValue("Name", this.undoManager.getRedoPresentationName());
    }

    @Override
    public void caretUpdate(CaretEvent arg0) {
        this.updateActions();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Component c = e.getComponent();
        if (c.isEnabled() && e.isPopupTrigger()) {
            this.popupMenu.show(c, e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Component c = e.getComponent();
        if (c.isEnabled() && e.isPopupTrigger()) {
            this.popupMenu.show(c, e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.undoManager.undoableEditHappened(e);
        this.updateActions();
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.updateActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEditActionListener(EditActionsListener editActionsListener) {
        Vector<EditActionsListener> vector = this.editActionsListenerList;
        synchronized (vector) {
            if (!this.editActionsListenerList.contains(editActionsListener)) {
                this.editActionsListenerList.add(editActionsListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEditActionListener(EditActionsListener editActionsListener) {
        Vector<EditActionsListener> vector = this.editActionsListenerList;
        synchronized (vector) {
            this.editActionsListenerList.remove(editActionsListener);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        for (EditActionsListener eal : this.editActionsListenerList) {
            eal.providesEditActions(this, this.editActions);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void discardAllEdits() {
        this.undoManager.discardAllEdits();
        this.updateActions();
    }

    public void release() {
        this.setPopupMenuActiv(false);
        this.clipboard.removeFlavorListener(this);
        this.textComponent.removeCaretListener(this);
        this.textComponent.getDocument().removeUndoableEditListener(this);
        this.textComponent.removeFocusListener(this);
        this.editActionsListenerList.clear();
        this.undoManager.discardAllEdits();
        this.undoManager = null;
        this.textComponent = null;
    }
}

