/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.dsp;

public class LPC {
    public static double autocorr(double[] sig, int N, int i) {
        double v = 0.0;
        int n = 0;
        while (n < N) {
            v += sig[n] * sig[n + i];
            ++n;
        }
        return v;
    }

    public static double[] autocorr(double[] x, int n) {
        int N = x.length - 1;
        double[] r = new double[n + 1];
        int i = 0;
        while (i < n + 1) {
            int j = 0;
            while (j <= N - i) {
                int n2 = i;
                r[n2] = r[n2] + x[j] * x[j + i];
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static double[] process(double[] x) {
        return LPC.process(x, x.length - 1);
    }

    public static double[] process(double[] x, int n) {
        double[] r = LPC.autocorr(x, n);
        return LPC.levinson(r, n);
    }

    public static double[] levinson(double[] r, int n) {
        double[] a_temp = new double[n + 1];
        double[] k = new double[n + 1];
        double[] a = new double[n + 1];
        k[0] = 0.0;
        a[0] = 1.0;
        a_temp[0] = 1.0;
        double alpha = r[0];
        int i = 1;
        while (i <= n) {
            double epsilon = r[i];
            int j = 1;
            while (j < i) {
                epsilon += a[j] * r[i - j];
                ++j;
            }
            a[i] = k[i] = -epsilon / alpha;
            alpha *= 1.0 - k[i] * k[i];
            j = 1;
            while (j < i) {
                a_temp[j] = a[j] + k[i] * a[i - j];
                ++j;
            }
            j = 1;
            while (j < i) {
                a[j] = a_temp[j];
                ++j;
            }
            ++i;
        }
        return a;
    }
}

