/*
 * Decompiled with CFR 0.152.
 */
package ipsk.beans;

import ipsk.beans.ExtBeanInfo;
import ipsk.beans.ExtBeanInfoImpl;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.Unit;
import ipsk.persistence.ObjectImmutableIfReferenced;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ExtendedIntrospector {
    private static Hashtable<Class, ExtBeanInfo> cache = new Hashtable();

    public static ExtBeanInfo getExtendedBeanInfo(Class<?> entityClass) throws IntrospectionException {
        return ExtendedIntrospector.getExtendedBeanInfo(entityClass, true, false);
    }

    public static ExtBeanInfo getExtendedBeanInfo(Class<?> beanClass, boolean searchEntitySuperClass, boolean acceptPersistenceClassesOnly) throws IntrospectionException {
        PluralResourceKey pluralResKeyClassAnno;
        ResourceKey resKeyClassAnno;
        Class<?> eClass;
        ExtBeanInfo cachedBi = cache.get(beanClass);
        if (cachedBi != null) {
            return cachedBi;
        }
        Class<?> entityClass = beanClass;
        boolean searchHierarchy = false;
        if (searchEntitySuperClass && (eClass = entityClass) != null) {
            entityClass = eClass;
        }
        BeanInfo bi = null;
        bi = Introspector.getBeanInfo(entityClass);
        ExtBeanInfoImpl impl = new ExtBeanInfoImpl(bi);
        ResourceBundleName resBundleAnno = ExtendedIntrospector.getAnnotationInHierarchy(entityClass, ResourceBundleName.class, searchHierarchy);
        if (resBundleAnno != null) {
            impl.setResourceBundleName(resBundleAnno.value());
        }
        if ((resKeyClassAnno = ExtendedIntrospector.getAnnotationInHierarchy(entityClass, ResourceKey.class, searchHierarchy)) != null) {
            impl.setClassResourceKey(resKeyClassAnno.value());
        }
        if ((pluralResKeyClassAnno = ExtendedIntrospector.getAnnotationInHierarchy(entityClass, PluralResourceKey.class, searchHierarchy)) != null) {
            impl.setClassPluralResourceKey(pluralResKeyClassAnno.value());
        }
        PreferredDisplayOrder prefDisplayOrderAnno = null;
        Class<?> sClass = entityClass;
        do {
            prefDisplayOrderAnno = sClass.getAnnotation(PreferredDisplayOrder.class);
            sClass = sClass.getSuperclass();
        } while (prefDisplayOrderAnno == null && sClass != null);
        if (prefDisplayOrderAnno != null) {
            StringTokenizer st = new StringTokenizer(prefDisplayOrderAnno.value(), ",");
            ArrayList<String> tmpList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                tmpList.add(st.nextToken().trim());
            }
            impl.setPreferredDisplayOrder(tmpList.toArray(new String[0]));
        }
        ArrayList<PropertyDescriptor> persistencePds = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            Method rm = pd.getReadMethod();
            if (rm != null && !pd.getName().equals("class")) {
                Unit unitAnno;
                persistencePds.add(pd);
                ResourceKey resKeyAnno = ExtendedIntrospector.getAnnotationInHierarchy(rm, ResourceKey.class, searchHierarchy);
                if (resKeyAnno != null) {
                    pd.setValue(ResourceKey.class.getName(), resKeyAnno.value());
                }
                if ((unitAnno = ExtendedIntrospector.getAnnotationInHierarchy(rm, Unit.class, searchHierarchy)) != null) {
                    pd.setValue(Unit.class.getName(), unitAnno.value());
                }
            }
            ++n2;
        }
        impl.setPersistencePropertyDescriptors(persistencePds.toArray(new PropertyDescriptor[0]));
        HashSet<PropertyDescriptor> referenceProperties = new HashSet<PropertyDescriptor>();
        sClass = entityClass;
        for (PropertyDescriptor pPd : persistencePds) {
            Method rm = pPd.getReadMethod();
            ObjectImmutableIfReferenced oiirAnno = rm.getAnnotation(ObjectImmutableIfReferenced.class);
            if (oiirAnno == null) continue;
            referenceProperties.add(pPd);
        }
        impl.setObjectImmutablePropertyDescriptors(referenceProperties);
        cache.put(beanClass, impl);
        return impl;
    }

    private static <T extends Annotation> T getAnnotationInHierarchy(Method method, Class<T> annotationClass, boolean searchHierarchy) {
        T anno = method.getAnnotation(annotationClass);
        if (anno != null || !searchHierarchy) {
            return anno;
        }
        Class methodClass = method.getDeclaringClass();
        Type sType = null;
        while ((sType = methodClass.getGenericSuperclass()) != null) {
            if (!(sType instanceof Class)) continue;
            Class sClass = (Class)sType;
            try {
                Method sMethod = sClass.getMethod(method.getName(), method.getParameterTypes());
                anno = sMethod.getAnnotation(annotationClass);
                if (anno != null) {
                    return anno;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            methodClass = sClass;
        }
        return null;
    }

    private static <A extends Annotation> A getAnnotationInHierarchy(Class<?> aClass, Class<A> annotationClass, boolean searchHierarchy) {
        do {
            A anno;
            if ((anno = aClass.getAnnotation(annotationClass)) == null && searchHierarchy) continue;
            return anno;
        } while ((aClass = aClass.getSuperclass()) != null);
        return null;
    }
}

